/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.http.policy;

import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.experimental.implementation.AccessTokenCacheImpl;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class BearerTokenAuthenticationChallengePolicy
implements HttpPipelinePolicy {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER = "Bearer";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private final AccessTokenCacheImpl cache;

    public BearerTokenAuthenticationChallengePolicy(TokenCredential credential) {
        Objects.requireNonNull(credential);
        this.cache = new AccessTokenCacheImpl(credential);
    }

    public Mono<Void> onBeforeRequest(HttpPipelineCallContext context) {
        return Mono.empty();
    }

    public Mono<Boolean> onChallenge(HttpPipelineCallContext context, HttpResponse response) {
        return Mono.just((Object)false);
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        if ("http".equals(context.getHttpRequest().getUrl().getProtocol())) {
            return Mono.error((Throwable)new RuntimeException("token credentials require a URL using the HTTPS protocol scheme"));
        }
        HttpPipelineNextPolicy nextPolicy = next.clone();
        return this.onBeforeRequest(context).then(Mono.defer(() -> next.process())).flatMap(httpResponse -> {
            String authHeader = httpResponse.getHeaderValue(WWW_AUTHENTICATE);
            if (httpResponse.getStatusCode() == 401 && authHeader != null) {
                return this.onChallenge(context, (HttpResponse)httpResponse).flatMap(retry -> {
                    if (retry.booleanValue()) {
                        return nextPolicy.process();
                    }
                    return Mono.just((Object)httpResponse);
                });
            }
            return Mono.just((Object)httpResponse);
        });
    }

    public Mono<Void> authorizeRequest(HttpPipelineCallContext context, TokenRequestContext tokenRequestContext) {
        return this.cache.getToken(tokenRequestContext).flatMap(token -> {
            context.getHttpRequest().getHeaders().set(AUTHORIZATION_HEADER, "Bearer " + token.getToken());
            return Mono.empty();
        });
    }
}

