/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.http;

import com.azure.core.util.logging.ClientLogger;
import java.util.Objects;

public final class HttpAuthorization {
    private final ClientLogger logger = new ClientLogger(HttpAuthorization.class);
    private final String scheme;
    private final String parameter;

    public HttpAuthorization(String scheme, String parameter) {
        Objects.requireNonNull(scheme);
        Objects.requireNonNull(parameter);
        if (scheme.isEmpty()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("scheme must be a nonempty string."));
        }
        if (parameter.isEmpty()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("parameter must be a nonempty string."));
        }
        this.scheme = scheme;
        this.parameter = parameter;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getParameter() {
        return this.parameter;
    }

    public String toString() {
        return String.format("%s %s", this.scheme, this.parameter);
    }
}

