/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.implementation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class AzureEnvironment {
    public static final String KEY_VAULT_DNS_SUFFIX = "keyVaultDnsSuffix";
    public static final String STORAGE_ENDPOINT_SUFFIX = "storageEndpointSuffix";
    public static final String AZURE_DATA_LAKE_STORE_FILE_SYSTEM_ENDPOINT_SUFFIX = "azureDataLakeStoreFileSystemEndpointSuffix";
    public static final String AZURE_DATA_LAKE_ANALYTICS_CATALOG_AND_JOB_ENDPOINT_SUFFIX = "azureDataLakeAnalyticsCatalogAndJobEndpointSuffix";
    public static final String PUBLISHING_PROFILE_URL = "publishingProfileUrl";
    public static final String MANAGEMENT_ENDPOINT_URL = "managementEndpointUrl";
    public static final String RESOURCE_MANAGER_ENDPOINT_URL = "resourceManagerEndpointUrl";
    public static final String SQL_MANAGEMENT_ENDPOINT_URL = "sqlManagementEndpointUrl";
    public static final String SQL_SERVER_HOSTNAME_SUFFIX = "sqlServerHostnameSuffix";
    public static final String GALLERY_ENDPOINT_URL = "galleryEndpointUrl";
    public static final String ACTIVE_DIRECTORY_ENDPOINT_URL = "activeDirectoryEndpointUrl";
    public static final String ACTIVE_DIRECTORY_RESOURCE_ID = "activeDirectoryResourceId";
    public static final String ACTIVE_DIRECTORY_GRAPH_RESOURCE_ID = "activeDirectoryGraphResourceId";
    public static final String MICROSOFT_GRAPH_RESOURCE_ID = "microsoftGraphResourceId";
    public static final String DATA_LAKE_ENDPOINT_RESOURCE_ID = "dataLakeEndpointResourceId";
    public static final String ACTIVE_DIRECTORY_GRAPH_API_VERSION = "activeDirectoryGraphApiVersion";
    public static final String AZURE_LOG_ANALYTICS_RESOURCE_ID = "azureLogAnalyticsResourceId";
    public static final String AZURE_APPLICATION_INSIGHTS_RESOURCE_ID = "azureApplicationInsightsResourceId";
    public static final String PORTAL_URL = "portalUrl";
    private final Map<String, String> endpoints;
    public static final AzureEnvironment AZURE = new AzureEnvironment((Map<String, String>)new HashMap<String, String>(){
        {
            this.put(AzureEnvironment.PORTAL_URL, "http://go.microsoft.com/fwlink/?LinkId=254433");
            this.put(AzureEnvironment.PUBLISHING_PROFILE_URL, "http://go.microsoft.com/fwlink/?LinkId=254432");
            this.put(AzureEnvironment.MANAGEMENT_ENDPOINT_URL, "https://management.core.windows.net/");
            this.put(AzureEnvironment.RESOURCE_MANAGER_ENDPOINT_URL, "https://management.azure.com/");
            this.put(AzureEnvironment.SQL_MANAGEMENT_ENDPOINT_URL, "https://management.core.windows.net:8443/");
            this.put(AzureEnvironment.SQL_SERVER_HOSTNAME_SUFFIX, ".database.windows.net");
            this.put(AzureEnvironment.GALLERY_ENDPOINT_URL, "https://gallery.azure.com/");
            this.put(AzureEnvironment.ACTIVE_DIRECTORY_ENDPOINT_URL, "https://login.microsoftonline.com/");
            this.put(AzureEnvironment.ACTIVE_DIRECTORY_RESOURCE_ID, "https://management.core.windows.net/");
            this.put(AzureEnvironment.ACTIVE_DIRECTORY_GRAPH_RESOURCE_ID, "https://graph.windows.net/");
            this.put(AzureEnvironment.MICROSOFT_GRAPH_RESOURCE_ID, "https://graph.microsoft.com/");
            this.put(AzureEnvironment.DATA_LAKE_ENDPOINT_RESOURCE_ID, "https://datalake.azure.net/");
            this.put(AzureEnvironment.ACTIVE_DIRECTORY_GRAPH_API_VERSION, "2013-04-05");
            this.put(AzureEnvironment.STORAGE_ENDPOINT_SUFFIX, ".core.windows.net");
            this.put(AzureEnvironment.KEY_VAULT_DNS_SUFFIX, ".vault.azure.net");
            this.put(AzureEnvironment.AZURE_DATA_LAKE_STORE_FILE_SYSTEM_ENDPOINT_SUFFIX, "azuredatalakestore.net");
            this.put(AzureEnvironment.AZURE_DATA_LAKE_ANALYTICS_CATALOG_AND_JOB_ENDPOINT_SUFFIX, "azuredatalakeanalytics.net");
            this.put(AzureEnvironment.AZURE_LOG_ANALYTICS_RESOURCE_ID, "https://api.loganalytics.io/");
            this.put(AzureEnvironment.AZURE_APPLICATION_INSIGHTS_RESOURCE_ID, "https://api.applicationinsights.io/");
        }
    });
    public static final AzureEnvironment AZURE_CHINA = new AzureEnvironment((Map<String, String>)new HashMap<String, String>(){
        {
            this.put(AzureEnvironment.PORTAL_URL, "http://go.microsoft.com/fwlink/?LinkId=301902");
            this.put(AzureEnvironment.PUBLISHING_PROFILE_URL, "http://go.microsoft.com/fwlink/?LinkID=301774");
            this.put(AzureEnvironment.MANAGEMENT_ENDPOINT_URL, "https://management.core.chinacloudapi.cn/");
            this.put(AzureEnvironment.RESOURCE_MANAGER_ENDPOINT_URL, "https://management.chinacloudapi.cn/");
            this.put(AzureEnvironment.SQL_MANAGEMENT_ENDPOINT_URL, "https://management.core.chinacloudapi.cn:8443/");
            this.put(AzureEnvironment.SQL_SERVER_HOSTNAME_SUFFIX, ".database.chinacloudapi.cn");
            this.put(AzureEnvironment.GALLERY_ENDPOINT_URL, "https://gallery.chinacloudapi.cn/");
            this.put(AzureEnvironment.ACTIVE_DIRECTORY_ENDPOINT_URL, "https://login.chinacloudapi.cn/");
            this.put(AzureEnvironment.ACTIVE_DIRECTORY_RESOURCE_ID, "https://management.core.chinacloudapi.cn/");
            this.put(AzureEnvironment.ACTIVE_DIRECTORY_GRAPH_RESOURCE_ID, "https://graph.chinacloudapi.cn/");
            this.put(AzureEnvironment.MICROSOFT_GRAPH_RESOURCE_ID, "https://microsoftgraph.chinacloudapi.cn/");
            this.put(AzureEnvironment.DATA_LAKE_ENDPOINT_RESOURCE_ID, "N/A");
            this.put(AzureEnvironment.ACTIVE_DIRECTORY_GRAPH_API_VERSION, "2013-04-05");
            this.put(AzureEnvironment.STORAGE_ENDPOINT_SUFFIX, ".core.chinacloudapi.cn");
            this.put(AzureEnvironment.KEY_VAULT_DNS_SUFFIX, ".vault.azure.cn");
            this.put(AzureEnvironment.AZURE_DATA_LAKE_STORE_FILE_SYSTEM_ENDPOINT_SUFFIX, "N/A");
            this.put(AzureEnvironment.AZURE_DATA_LAKE_ANALYTICS_CATALOG_AND_JOB_ENDPOINT_SUFFIX, "N/A");
            this.put(AzureEnvironment.AZURE_LOG_ANALYTICS_RESOURCE_ID, "N/A");
            this.put(AzureEnvironment.AZURE_APPLICATION_INSIGHTS_RESOURCE_ID, "N/A");
        }
    });
    public static final AzureEnvironment AZURE_US_GOVERNMENT = new AzureEnvironment((Map<String, String>)new HashMap<String, String>(){
        {
            this.put(AzureEnvironment.PORTAL_URL, "https://manage.windowsazure.us");
            this.put(AzureEnvironment.PUBLISHING_PROFILE_URL, "https://manage.windowsazure.us/publishsettings/index");
            this.put(AzureEnvironment.MANAGEMENT_ENDPOINT_URL, "https://management.core.usgovcloudapi.net/");
            this.put(AzureEnvironment.RESOURCE_MANAGER_ENDPOINT_URL, "https://management.usgovcloudapi.net/");
            this.put(AzureEnvironment.SQL_MANAGEMENT_ENDPOINT_URL, "https://management.core.usgovcloudapi.net:8443/");
            this.put(AzureEnvironment.SQL_SERVER_HOSTNAME_SUFFIX, ".database.usgovcloudapi.net");
            this.put(AzureEnvironment.GALLERY_ENDPOINT_URL, "https://gallery.usgovcloudapi.net/");
            this.put(AzureEnvironment.ACTIVE_DIRECTORY_ENDPOINT_URL, "https://login.microsoftonline.us/");
            this.put(AzureEnvironment.ACTIVE_DIRECTORY_RESOURCE_ID, "https://management.core.usgovcloudapi.net/");
            this.put(AzureEnvironment.ACTIVE_DIRECTORY_GRAPH_RESOURCE_ID, "https://graph.windows.net/");
            this.put(AzureEnvironment.MICROSOFT_GRAPH_RESOURCE_ID, "https://graph.microsoft.us/");
            this.put(AzureEnvironment.DATA_LAKE_ENDPOINT_RESOURCE_ID, "N/A");
            this.put(AzureEnvironment.ACTIVE_DIRECTORY_GRAPH_API_VERSION, "2013-04-05");
            this.put(AzureEnvironment.STORAGE_ENDPOINT_SUFFIX, ".core.usgovcloudapi.net");
            this.put(AzureEnvironment.KEY_VAULT_DNS_SUFFIX, ".vault.usgovcloudapi.net");
            this.put(AzureEnvironment.AZURE_DATA_LAKE_STORE_FILE_SYSTEM_ENDPOINT_SUFFIX, "N/A");
            this.put(AzureEnvironment.AZURE_DATA_LAKE_ANALYTICS_CATALOG_AND_JOB_ENDPOINT_SUFFIX, "N/A");
            this.put(AzureEnvironment.AZURE_LOG_ANALYTICS_RESOURCE_ID, "https://api.loganalytics.us/");
            this.put(AzureEnvironment.AZURE_APPLICATION_INSIGHTS_RESOURCE_ID, "N/A");
        }
    });
    public static final AzureEnvironment AZURE_GERMANY = new AzureEnvironment((Map<String, String>)new HashMap<String, String>(){
        {
            this.put(AzureEnvironment.PORTAL_URL, "http://portal.microsoftazure.de/");
            this.put(AzureEnvironment.PUBLISHING_PROFILE_URL, "https://manage.microsoftazure.de/publishsettings/index");
            this.put(AzureEnvironment.MANAGEMENT_ENDPOINT_URL, "https://management.core.cloudapi.de/");
            this.put(AzureEnvironment.RESOURCE_MANAGER_ENDPOINT_URL, "https://management.microsoftazure.de/");
            this.put(AzureEnvironment.SQL_MANAGEMENT_ENDPOINT_URL, "https://management.core.cloudapi.de:8443/");
            this.put(AzureEnvironment.SQL_SERVER_HOSTNAME_SUFFIX, ".database.cloudapi.de");
            this.put(AzureEnvironment.GALLERY_ENDPOINT_URL, "https://gallery.cloudapi.de/");
            this.put(AzureEnvironment.ACTIVE_DIRECTORY_ENDPOINT_URL, "https://login.microsoftonline.de/");
            this.put(AzureEnvironment.ACTIVE_DIRECTORY_RESOURCE_ID, "https://management.core.cloudapi.de/");
            this.put(AzureEnvironment.ACTIVE_DIRECTORY_GRAPH_RESOURCE_ID, "https://graph.cloudapi.de/");
            this.put(AzureEnvironment.MICROSOFT_GRAPH_RESOURCE_ID, "https://graph.microsoft.de/");
            this.put(AzureEnvironment.DATA_LAKE_ENDPOINT_RESOURCE_ID, "N/A");
            this.put(AzureEnvironment.ACTIVE_DIRECTORY_GRAPH_API_VERSION, "2013-04-05");
            this.put(AzureEnvironment.STORAGE_ENDPOINT_SUFFIX, ".core.cloudapi.de");
            this.put(AzureEnvironment.KEY_VAULT_DNS_SUFFIX, ".vault.microsoftazure.de");
            this.put(AzureEnvironment.AZURE_DATA_LAKE_STORE_FILE_SYSTEM_ENDPOINT_SUFFIX, "N/A");
            this.put(AzureEnvironment.AZURE_DATA_LAKE_ANALYTICS_CATALOG_AND_JOB_ENDPOINT_SUFFIX, "N/A");
            this.put(AzureEnvironment.AZURE_LOG_ANALYTICS_RESOURCE_ID, "N/A");
            this.put(AzureEnvironment.AZURE_APPLICATION_INSIGHTS_RESOURCE_ID, "N/A");
        }
    });

    public AzureEnvironment(Map<String, String> endpoints) {
        this.endpoints = endpoints;
    }

    public Map<String, String> getEndpoints() {
        return this.endpoints;
    }

    public static List<AzureEnvironment> knownEnvironments() {
        return Arrays.asList(AZURE, AZURE_CHINA, AZURE_GERMANY, AZURE_US_GOVERNMENT);
    }

    public String getPortal() {
        return this.endpoints.get(PORTAL_URL);
    }

    public String getPublishingProfile() {
        return this.endpoints.get(PUBLISHING_PROFILE_URL);
    }

    public String getManagementEndpoint() {
        return this.endpoints.get(MANAGEMENT_ENDPOINT_URL);
    }

    public String getResourceManagerEndpoint() {
        return this.endpoints.get(RESOURCE_MANAGER_ENDPOINT_URL);
    }

    public String getSqlManagementEndpoint() {
        return this.endpoints.get(SQL_MANAGEMENT_ENDPOINT_URL);
    }

    public String getActiveDirectoryResourceId() {
        return this.endpoints.get(ACTIVE_DIRECTORY_RESOURCE_ID);
    }

    public String getGalleryEndpoint() {
        return this.endpoints.get(GALLERY_ENDPOINT_URL);
    }

    public String getGraphEndpoint() {
        return this.endpoints.get(ACTIVE_DIRECTORY_GRAPH_RESOURCE_ID);
    }

    public String getMicrosoftGraphEndpoint() {
        return this.endpoints.get(MICROSOFT_GRAPH_RESOURCE_ID);
    }

    public String getDataLakeEndpointResourceId() {
        return this.endpoints.get(DATA_LAKE_ENDPOINT_RESOURCE_ID);
    }

    public String getActiveDirectoryGraphApiVersion() {
        return this.endpoints.get(ACTIVE_DIRECTORY_GRAPH_API_VERSION);
    }

    public String getStorageEndpointSuffix() {
        return this.endpoints.get(STORAGE_ENDPOINT_SUFFIX);
    }

    public String getKeyVaultDnsSuffix() {
        return this.endpoints.get(KEY_VAULT_DNS_SUFFIX);
    }

    public String getAzureDataLakeStoreFileSystemEndpointSuffix() {
        return this.endpoints.get(AZURE_DATA_LAKE_STORE_FILE_SYSTEM_ENDPOINT_SUFFIX);
    }

    public String getAzureDataLakeAnalyticsCatalogAndJobEndpointSuffix() {
        return this.endpoints.get(AZURE_DATA_LAKE_ANALYTICS_CATALOG_AND_JOB_ENDPOINT_SUFFIX);
    }

    public String getLogAnalyticsEndpoint() {
        return this.endpoints.get(AZURE_LOG_ANALYTICS_RESOURCE_ID);
    }

    public String getApplicationInsightsEndpoint() {
        return this.endpoints.get(AZURE_APPLICATION_INSIGHTS_RESOURCE_ID);
    }

    public String getUrlByEndpoint(Endpoint endpoint) {
        return this.endpoints.get(endpoint.identifier());
    }

    public static enum Endpoint {
        MANAGEMENT("managementEndpointUrl"),
        RESOURCE_MANAGER("resourceManagerEndpointUrl"),
        SQL("sqlManagementEndpointUrl"),
        GALLERY("galleryEndpointUrl"),
        ACTIVE_DIRECTORY("activeDirectoryEndpointUrl"),
        GRAPH("activeDirectoryGraphResourceId"),
        KEYVAULT("keyVaultDnsSuffix"),
        DATA_LAKE_STORE("azureDataLakeStoreFileSystemEndpointSuffix"),
        DATA_LAKE_ANALYTICS("azureDataLakeAnalyticsCatalogAndJobEndpointSuffix"),
        LOG_ANALYTICS("azureLogAnalyticsResourceId"),
        APPLICATION_INSIGHTS("azureApplicationInsightsResourceId"),
        MICROSOFT_GRAPH("microsoftGraphResourceId");

        private final String field;

        private Endpoint(String value) {
            this.field = value;
        }

        public String identifier() {
            return this.field;
        }

        public String toString() {
            return this.field;
        }
    }
}

