/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.models;

import com.azure.core.util.logging.ClientLogger;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Objects;

public final class TimeInterval {
    public static final TimeInterval ALL = new TimeInterval(OffsetDateTime.MIN, OffsetDateTime.MAX);
    public static final TimeInterval LAST_5_MINUTES = new TimeInterval(Duration.ofMinutes(5L));
    public static final TimeInterval LAST_30_MINUTES = new TimeInterval(Duration.ofMinutes(30L));
    public static final TimeInterval LAST_1_HOUR = new TimeInterval(Duration.ofHours(1L));
    public static final TimeInterval LAST_4_HOURS = new TimeInterval(Duration.ofHours(4L));
    public static final TimeInterval LAST_12_HOURS = new TimeInterval(Duration.ofHours(12L));
    public static final TimeInterval LAST_DAY = new TimeInterval(Duration.ofDays(1L));
    public static final TimeInterval LAST_2_DAYS = new TimeInterval(Duration.ofDays(2L));
    public static final TimeInterval LAST_3_DAYS = new TimeInterval(Duration.ofDays(3L));
    public static final TimeInterval LAST_7_DAYS = new TimeInterval(Duration.ofDays(7L));
    private static final ClientLogger LOGGER = new ClientLogger(TimeInterval.class);
    private static final String ERROR_MESSAGE = "%s is an invalid time interval. It must be in one of the following ISO 8601 time interval formats: duration, startDuration/endTime, startTime/endTime, startTime/endDuration";
    private final Duration duration;
    private final OffsetDateTime startTime;
    private final OffsetDateTime endTime;

    public TimeInterval(Duration duration) {
        this.duration = Objects.requireNonNull(duration, "'duration' cannot be null");
        this.startTime = null;
        this.endTime = null;
    }

    public TimeInterval(OffsetDateTime startTime, OffsetDateTime endTime) {
        this.startTime = Objects.requireNonNull(startTime, "'startTime' cannot be null");
        this.endTime = Objects.requireNonNull(endTime, "'endTime' cannot be null");
        this.duration = null;
    }

    public TimeInterval(OffsetDateTime startTime, Duration duration) {
        this.startTime = Objects.requireNonNull(startTime, "'startTime' cannot be null");
        this.duration = Objects.requireNonNull(duration, "'duration' cannot be null");
        this.endTime = null;
    }

    TimeInterval(Duration duration, OffsetDateTime endTime) {
        this.endTime = Objects.requireNonNull(endTime, "'endTime' cannot be null");
        this.duration = Objects.requireNonNull(duration, "'duration' cannot be null");
        this.startTime = null;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public OffsetDateTime getStartTime() {
        if (this.startTime != null) {
            return this.startTime;
        }
        if (this.duration != null && this.endTime != null) {
            return this.endTime.minusNanos(this.duration.toNanos());
        }
        return null;
    }

    public OffsetDateTime getEndTime() {
        if (this.endTime != null) {
            return this.endTime;
        }
        if (this.startTime != null && this.duration != null) {
            return this.startTime.plusNanos(this.duration.toNanos());
        }
        return null;
    }

    public String toIso8601Format() {
        if (this.startTime != null && this.endTime != null) {
            return this.startTime + "/" + this.endTime;
        }
        if (this.startTime != null && this.duration != null) {
            return this.startTime + "/" + this.duration;
        }
        if (this.duration != null && this.endTime != null) {
            return this.duration + "/" + this.endTime;
        }
        return this.duration == null ? null : this.duration.toString();
    }

    public static TimeInterval parse(String value) {
        Objects.requireNonNull(value);
        String[] parts = value.split("/");
        if (parts.length == 1) {
            Duration duration = TimeInterval.parseDuration(parts[0]);
            if (duration == null || parts[0].length() + 1 == value.length()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format(ERROR_MESSAGE, value)));
            }
            return new TimeInterval(duration);
        }
        if (parts.length == 2) {
            Duration startDuration = TimeInterval.parseDuration(parts[0]);
            OffsetDateTime startTime = TimeInterval.parseTime(parts[0]);
            Duration endDuration = TimeInterval.parseDuration(parts[1]);
            OffsetDateTime endTime = TimeInterval.parseTime(parts[1]);
            if (startDuration != null && endTime != null) {
                return new TimeInterval(startDuration, endTime);
            }
            if (startTime != null && endTime != null) {
                return new TimeInterval(startTime, endTime);
            }
            if (startTime != null && endDuration != null) {
                return new TimeInterval(startTime, endDuration);
            }
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format(ERROR_MESSAGE, value)));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (this.duration != null && this.endTime != null) {
            sb.append("duration: ").append(this.duration).append(", ").append("end time: ").append(this.endTime);
        } else if (this.startTime != null && this.endTime != null) {
            sb.append("start time: ").append(this.startTime).append(", ").append("end time: ").append(this.endTime);
        } else if (this.startTime != null && this.duration != null) {
            sb.append("start time: ").append(this.startTime).append(", ").append("duration: ").append(this.duration);
        } else {
            sb.append("duration: ").append(this.duration);
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeInterval that = (TimeInterval)o;
        return Objects.equals(this.duration, that.duration) && Objects.equals(this.startTime, that.startTime) && Objects.equals(this.endTime, that.endTime);
    }

    public int hashCode() {
        return Objects.hash(this.duration, this.startTime, this.endTime);
    }

    private static OffsetDateTime parseTime(String value) {
        try {
            return OffsetDateTime.parse(value);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Duration parseDuration(String value) {
        try {
            return Duration.parse(value);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

