/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.http;

import com.azure.core.experimental.http.DynamicResponse;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.ObjectSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DynamicRequest {
    private final ClientLogger logger = new ClientLogger(DynamicRequest.class);
    private final ObjectSerializer objectSerializer;
    private final HttpPipeline httpPipeline;
    private HttpHeaders headers = new HttpHeaders();
    private final Map<String, String> queries = new HashMap<String, String>();
    private HttpMethod httpMethod;
    private String url;
    private byte[] body;

    public DynamicRequest(ObjectSerializer objectSerializer, HttpPipeline httpPipeline) {
        if (objectSerializer == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("objectSerializer cannot be null"));
        }
        if (httpPipeline == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("httpPipeline cannot be null"));
        }
        this.objectSerializer = objectSerializer;
        this.httpPipeline = httpPipeline;
    }

    public ObjectSerializer getObjectSerializer() {
        return this.objectSerializer;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public DynamicRequest setUrl(String url) {
        this.url = url;
        return this;
    }

    public DynamicRequest setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    @Deprecated
    public DynamicRequest addHeader(String header, String value) {
        this.headers.set(header, value);
        return this;
    }

    public DynamicRequest addHeader(HttpHeaderName header, String value) {
        this.headers.set(header, value);
        return this;
    }

    public DynamicRequest addHeader(HttpHeader httpHeader) {
        if (httpHeader == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("httpHeader cannot be null"));
        }
        this.headers.set(httpHeader.getName(), httpHeader.getValue());
        return this;
    }

    public DynamicRequest setHeaders(HttpHeaders httpHeaders) {
        this.headers = httpHeaders;
        return this;
    }

    public DynamicRequest setBody(String body) {
        this.body = body.getBytes(StandardCharsets.UTF_8);
        return this;
    }

    public DynamicRequest setBody(Object body) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.objectSerializer.serialize((OutputStream)outputStream, body);
            this.body = outputStream.toByteArray();
            outputStream.close();
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError((RuntimeException)new UncheckedIOException("Unable to serialize the body", e));
        }
        return this;
    }

    public DynamicRequest setPathParam(String parameterName, String value) {
        if (!this.url.contains("{" + parameterName + "}")) {
            throw (IllegalArgumentException)this.logger.logThrowableAsError((Throwable)new IllegalArgumentException("no path param \"" + parameterName + "\""));
        }
        this.url = this.url.replace("{" + parameterName + "}", value);
        return this;
    }

    public DynamicRequest addQueryParam(String parameterName, String value) {
        this.queries.put(parameterName, value);
        return this;
    }

    private HttpRequest buildRequest() {
        if (this.url == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("url cannot be null"));
        }
        if (this.httpMethod == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("httpMethod cannot be null"));
        }
        if (!this.queries.isEmpty()) {
            this.url = this.url + (this.url.contains("?") ? "&" : "?");
            this.url = this.url + this.queries.keySet().stream().map(key -> key + "=" + this.queries.get(key)).collect(Collectors.joining("&"));
        }
        HttpRequest request = new HttpRequest(this.httpMethod, this.url);
        if (this.headers != null) {
            request = request.setHeaders(this.headers);
        }
        if (this.body != null && this.body.length != 0) {
            request = request.setBody(this.body);
        }
        return request;
    }

    public DynamicResponse send() {
        return this.send(Context.NONE);
    }

    public DynamicResponse send(Context context) {
        return (DynamicResponse)this.sendAsync(context).block();
    }

    public Mono<DynamicResponse> sendAsync() {
        return FluxUtil.withContext(this::sendAsync);
    }

    private Mono<DynamicResponse> sendAsync(Context context) {
        return this.httpPipeline.send(this.buildRequest(), context).flatMap(httpResponse -> BinaryData.fromFlux((Flux)httpResponse.getBody()).map(data -> new DynamicResponse((HttpResponse)httpResponse, (BinaryData)data)));
    }
}

