/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.util.polling;

import com.azure.core.exception.AzureException;
import com.azure.core.experimental.util.polling.implementation.PostPollResult;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.implementation.ImplUtils;
import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.PollingStrategyOptions;
import com.azure.core.util.polling.SyncOperationResourcePollingStrategy;
import com.azure.core.util.polling.implementation.PollingUtils;
import com.azure.core.util.serializer.JsonSerializerProviders;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import java.time.Duration;
import java.time.OffsetDateTime;

public class SyncOperationLocationPollingStrategy<T, U>
extends SyncOperationResourcePollingStrategy<T, U> {
    private static final ClientLogger LOGGER = new ClientLogger(SyncOperationLocationPollingStrategy.class);
    private static final HttpHeaderName OPERATION_LOCATION_HEADER = HttpHeaderName.fromString((String)"Operation-Location");
    private static final TypeReference<PostPollResult> POST_POLL_RESULT_TYPE_REFERENCE = TypeReference.createInstance(PostPollResult.class);
    private final ObjectSerializer serializer;
    private final String endpoint;

    public SyncOperationLocationPollingStrategy(PollingStrategyOptions pollingStrategyOptions) {
        super(OPERATION_LOCATION_HEADER, pollingStrategyOptions);
        this.endpoint = pollingStrategyOptions.getEndpoint();
        this.serializer = pollingStrategyOptions.getSerializer() != null ? pollingStrategyOptions.getSerializer() : JsonSerializerProviders.createInstance((boolean)true);
    }

    public PollResponse<T> onInitialResponse(Response<?> response, PollingContext<T> pollingContext, TypeReference<T> pollResponseType) {
        HttpHeader operationLocationHeader = response.getHeaders().get(OPERATION_LOCATION_HEADER);
        if (operationLocationHeader != null) {
            pollingContext.setData(OPERATION_LOCATION_HEADER.getCaseSensitiveName(), PollingUtils.getAbsolutePath((String)operationLocationHeader.getValue(), (String)this.endpoint, (ClientLogger)LOGGER));
        }
        String httpMethod = response.getRequest().getHttpMethod().name();
        pollingContext.setData("httpMethod", httpMethod);
        if (response.getStatusCode() == 200 || response.getStatusCode() == 201 || response.getStatusCode() == 202 || response.getStatusCode() == 204) {
            Duration retryAfter = ImplUtils.getRetryAfterFromHeaders((HttpHeaders)response.getHeaders(), OffsetDateTime::now);
            if (HttpMethod.PUT.name().equalsIgnoreCase(httpMethod) || HttpMethod.PATCH.name().equalsIgnoreCase(httpMethod)) {
                BinaryData initialResponseBody = PollingUtils.serializeResponseSync((Object)response.getValue(), (ObjectSerializer)this.serializer);
                pollingContext.setData("initialResourceResponseBody", initialResponseBody.toString());
                return new PollResponse(LongRunningOperationStatus.IN_PROGRESS, null, retryAfter);
            }
            return new PollResponse(LongRunningOperationStatus.IN_PROGRESS, PollingUtils.convertResponseSync((Object)response.getValue(), (ObjectSerializer)this.serializer, pollResponseType), retryAfter);
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new AzureException(String.format("Operation failed or cancelled with status code %d, '%s' header: %s, and response body: %s", response.getStatusCode(), OPERATION_LOCATION_HEADER, operationLocationHeader, PollingUtils.serializeResponseSync((Object)response.getValue(), (ObjectSerializer)this.serializer))));
    }

    public U getResult(PollingContext<T> pollingContext, TypeReference<U> resultType) {
        if (pollingContext.getLatestResponse().getStatus() == LongRunningOperationStatus.FAILED) {
            throw LOGGER.logExceptionAsError((RuntimeException)new AzureException("Long running operation failed."));
        }
        if (pollingContext.getLatestResponse().getStatus() == LongRunningOperationStatus.USER_CANCELLED) {
            throw LOGGER.logExceptionAsError((RuntimeException)new AzureException("Long running operation cancelled."));
        }
        String httpMethod = pollingContext.getData("httpMethod");
        if (HttpMethod.PUT.name().equalsIgnoreCase(httpMethod) || HttpMethod.PATCH.name().equalsIgnoreCase(httpMethod)) {
            BinaryData initialResponseBody = BinaryData.fromString((String)pollingContext.getData("initialResourceResponseBody"));
            return (U)PollingUtils.deserializeResponseSync((BinaryData)initialResponseBody, (ObjectSerializer)this.serializer, resultType);
        }
        if (HttpMethod.POST.name().equalsIgnoreCase(httpMethod)) {
            BinaryData latestResponseBody = BinaryData.fromString((String)pollingContext.getData("pollResponseBody"));
            PostPollResult pollResult = (PostPollResult)PollingUtils.deserializeResponseSync((BinaryData)latestResponseBody, (ObjectSerializer)this.serializer, POST_POLL_RESULT_TYPE_REFERENCE);
            if (pollResult != null && pollResult.getResult() != null) {
                return (U)PollingUtils.deserializeResponseSync((BinaryData)pollResult.getResult(), (ObjectSerializer)this.serializer, resultType);
            }
            throw LOGGER.logExceptionAsError((RuntimeException)new AzureException("Cannot get final result"));
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new AzureException("Cannot get final result"));
    }
}

