/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.credential;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.experimental.credential.PopTokenRequestContext;
import com.azure.core.experimental.implementation.AccessTokenCache;
import com.azure.core.experimental.implementation.AuthorizationChallengeParser;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class PopTokenAuthenticationPolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(PopTokenAuthenticationPolicy.class);
    private final List<String> scopes = new ArrayList<String>();
    private final AccessTokenCache cache;
    private String popNonce;

    public PopTokenAuthenticationPolicy(TokenCredential credential, String ... scopes) {
        Objects.requireNonNull(credential);
        this.scopes.clear();
        this.scopes.addAll(Arrays.asList(scopes));
        this.cache = new AccessTokenCache(credential);
    }

    public Mono<Void> authorizeRequest(HttpPipelineCallContext context) {
        return this.scopes == null ? Mono.empty() : this.setAuthorizationHeaderHelper(context, false);
    }

    public void authorizeRequestSync(HttpPipelineCallContext context) {
        this.setAuthorizationHeaderHelperSync(context, false);
    }

    public Mono<Boolean> authorizeRequestOnChallenge(HttpPipelineCallContext context, HttpResponse response) {
        this.popNonce = AuthorizationChallengeParser.getChallengeParameterFromResponse(response, "PoP", "nonce");
        if (CoreUtils.isNullOrEmpty((CharSequence)this.popNonce)) {
            return Mono.just((Object)false);
        }
        return this.scopes == null ? Mono.just((Object)false) : this.setAuthorizationHeaderHelper(context, true).flatMap(ignored -> Mono.just((Object)true));
    }

    public boolean authorizeRequestOnChallengeSync(HttpPipelineCallContext context, HttpResponse response) {
        this.popNonce = AuthorizationChallengeParser.getChallengeParameterFromResponse(response, "PoP", "nonce");
        if (CoreUtils.isNullOrEmpty((CharSequence)this.popNonce)) {
            return false;
        }
        if (this.scopes == null) {
            return false;
        }
        this.setAuthorizationHeaderHelperSync(context, true);
        return true;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        if (!"https".equals(context.getHttpRequest().getUrl().getProtocol())) {
            return Mono.error((Throwable)new RuntimeException("Proof of possession token authentication is not permitted for non TLS-protected (HTTPS) endpoints."));
        }
        HttpPipelineNextPolicy nextPolicy = next.clone();
        return this.authorizeRequest(context).then(Mono.defer(() -> ((HttpPipelineNextPolicy)next).process())).flatMap(httpResponse -> {
            String authHeader = httpResponse.getHeaderValue(HttpHeaderName.WWW_AUTHENTICATE);
            if (httpResponse.getStatusCode() == 401 && authHeader != null) {
                return this.authorizeRequestOnChallenge(context, (HttpResponse)httpResponse).flatMap(authorized -> {
                    if (authorized.booleanValue()) {
                        httpResponse.close();
                        return nextPolicy.process();
                    }
                    return Mono.just((Object)httpResponse);
                });
            }
            if (authHeader != null) {
                this.popNonce = AuthorizationChallengeParser.getChallengeParameterFromResponse(httpResponse, "PoP", "nonce");
            }
            return Mono.just((Object)httpResponse);
        });
    }

    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        if (!"https".equals(context.getHttpRequest().getUrl().getProtocol())) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Proof of possession token authentication is not permitted for non TLS-protected (HTTPS) endpoints."));
        }
        HttpPipelineNextSyncPolicy nextPolicy = next.clone();
        this.authorizeRequestSync(context);
        HttpResponse httpResponse = next.processSync();
        String authHeader = httpResponse.getHeaderValue(HttpHeaderName.WWW_AUTHENTICATE);
        if (httpResponse.getStatusCode() == 401 && authHeader != null) {
            if (this.authorizeRequestOnChallengeSync(context, httpResponse)) {
                httpResponse.close();
                return nextPolicy.processSync();
            }
            return httpResponse;
        }
        if (authHeader != null) {
            this.popNonce = AuthorizationChallengeParser.getChallengeParameterFromResponse(httpResponse, "PoP", "nonce");
            return httpResponse;
        }
        return httpResponse;
    }

    private Mono<Void> setAuthorizationHeaderHelper(HttpPipelineCallContext context, boolean checkToForceFetchToken) {
        if (!"https".equals(context.getHttpRequest().getUrl().getProtocol())) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Proof of possession token authentication is not permitted for non TLS-protected (HTTPS) endpoints."));
        }
        PopTokenRequestContext popTokenRequestContext = new PopTokenRequestContext().addScopes(this.scopes.get(0)).setProofOfPossessionNonce(this.popNonce).setResourceRequestUrl(context.getHttpRequest().getUrl()).setResourceRequestMethod(context.getHttpRequest().getHttpMethod());
        if (!CoreUtils.isNullOrEmpty((CharSequence)this.popNonce)) {
            return this.cache.getToken(popTokenRequestContext, checkToForceFetchToken).flatMap(token -> {
                PopTokenAuthenticationPolicy.setAuthorizationHeader(context.getHttpRequest().getHeaders(), token.getToken());
                return Mono.empty();
            });
        }
        return Mono.empty();
    }

    private void setAuthorizationHeaderHelperSync(HttpPipelineCallContext context, boolean checkToForceFetchToken) {
        if (!"https".equals(context.getHttpRequest().getUrl().getProtocol())) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Proof of possession token authentication is not permitted for non TLS-protected (HTTPS) endpoints."));
        }
        PopTokenRequestContext popTokenRequestContext = new PopTokenRequestContext().addScopes(this.scopes.get(0)).setProofOfPossessionNonce(this.popNonce).setResourceRequestUrl(context.getHttpRequest().getUrl()).setResourceRequestMethod(context.getHttpRequest().getHttpMethod());
        AccessToken token = this.cache.getTokenSync(popTokenRequestContext, checkToForceFetchToken);
        PopTokenAuthenticationPolicy.setAuthorizationHeader(context.getHttpRequest().getHeaders(), token.getToken());
    }

    private static void setAuthorizationHeader(HttpHeaders headers, String token) {
        headers.set(HttpHeaderName.AUTHORIZATION, "Pop " + token);
    }
}

