/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.credential;

import com.azure.core.credential.TokenRequestContext;
import com.azure.core.http.HttpMethod;
import com.azure.core.util.logging.ClientLogger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PopTokenRequestContext
extends TokenRequestContext {
    private static final ClientLogger LOGGER = new ClientLogger(PopTokenRequestContext.class);
    private final List<String> scopes = new ArrayList<String>();
    private String claims;
    private String tenantId;
    private boolean isCaeEnabled;
    private String proofOfPossessionNonce;
    private boolean isProofOfPossessionEnabled;
    private URL requestUrl;
    private HttpMethod requestMethod;

    public PopTokenRequestContext addScopes(String ... scopes) {
        this.scopes.addAll(Arrays.asList(scopes));
        return this;
    }

    public PopTokenRequestContext setClaims(String claims) {
        this.claims = claims;
        return this;
    }

    public PopTokenRequestContext setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public PopTokenRequestContext setCaeEnabled(boolean caeEnabled) {
        this.isCaeEnabled = caeEnabled;
        return this;
    }

    public PopTokenRequestContext setProofOfPossessionNonce(String proofOfPossessionNonce) {
        this.proofOfPossessionNonce = proofOfPossessionNonce;
        return this;
    }

    public String getClaims() {
        return this.claims;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public boolean isCaeEnabled() {
        return this.isCaeEnabled;
    }

    public String getProofOfPossessionNonce() {
        return this.proofOfPossessionNonce;
    }

    public String getResourceRequestMethod() {
        return this.requestMethod != null ? this.requestMethod.toString() : null;
    }

    public PopTokenRequestContext setResourceRequestMethod(HttpMethod resourceRequestMethod) {
        this.requestMethod = resourceRequestMethod;
        return this;
    }

    public URL getResourceRequestUrl() {
        return this.requestUrl;
    }

    public PopTokenRequestContext setResourceRequestUrl(URL resourceRequestUrl) {
        this.requestUrl = resourceRequestUrl;
        return this;
    }

    public TokenRequestContext setProofOfPossessionEnabled(boolean enableProofOfPossession) {
        this.isProofOfPossessionEnabled = enableProofOfPossession;
        return this;
    }

    public boolean isProofOfPossessionEnabled() {
        return this.isProofOfPossessionEnabled;
    }
}

