/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.implementation;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpResponse;
import java.util.HashMap;
import java.util.Map;

public class AuthorizationChallengeParser {
    public static String getChallengeParameterFromResponse(HttpResponse response, String challengeScheme, String parameter) {
        String headerValue = response.getHeaderValue(HttpHeaderName.WWW_AUTHENTICATE);
        return AuthorizationChallengeParser.getChallengeParameter(headerValue, challengeScheme, parameter);
    }

    static String getChallengeParameter(String challengeResponse, String challengeScheme, String parameter) {
        if (challengeResponse == null || challengeResponse.isEmpty()) {
            return null;
        }
        if (!challengeResponse.startsWith(challengeScheme)) {
            return null;
        }
        String challenge = challengeResponse.substring(challengeScheme.length()).trim();
        Map<String, String> challengeParameters = AuthorizationChallengeParser.parseChallengeParameters(challenge);
        return challengeParameters.get(parameter);
    }

    private static Map<String, String> parseChallengeParameters(String challenge) {
        int equalsIndex;
        HashMap<String, String> parameters = new HashMap<String, String>();
        int length = challenge.length();
        int start = 0;
        while (start < length && (equalsIndex = challenge.indexOf(61, start)) != -1) {
            String value;
            String key = challenge.substring(start, equalsIndex).trim();
            int commaIndex = challenge.indexOf(44, equalsIndex + 1);
            if (commaIndex == -1) {
                commaIndex = length;
            }
            if ((value = challenge.substring(equalsIndex + 1, commaIndex).trim()).startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            parameters.put(key, value);
            start = commaIndex + 1;
        }
        return parameters;
    }
}

