/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.serializer;

import com.azure.core.experimental.serializer.AvroSerializer;
import com.azure.core.experimental.serializer.AvroSerializerProvider;
import java.util.Iterator;
import java.util.ServiceLoader;

public final class AvroSerializerProviders {
    private static boolean loadAttempted;
    private static AvroSerializerProvider defaultProvider;
    private static final IllegalStateException NO_AVRO_SERIALIZER_EXCEPTION;

    private AvroSerializerProviders() {
    }

    private static synchronized void load() {
        if (loadAttempted) {
            if (defaultProvider == null) {
                throw NO_AVRO_SERIALIZER_EXCEPTION;
            }
            return;
        }
        loadAttempted = true;
        Iterator<AvroSerializerProvider> it = ServiceLoader.load(AvroSerializerProvider.class).iterator();
        if (!it.hasNext()) {
            throw NO_AVRO_SERIALIZER_EXCEPTION;
        }
        defaultProvider = it.next();
    }

    public static AvroSerializer createInstance(String schema) {
        if (defaultProvider == null) {
            AvroSerializerProviders.load();
        }
        return defaultProvider.createInstance(schema);
    }

    public static String getSchema(Object object) {
        if (defaultProvider == null) {
            AvroSerializerProviders.load();
        }
        return defaultProvider.getSchema(object);
    }

    public static String getSchemaName(Object object) {
        if (defaultProvider == null) {
            AvroSerializerProviders.load();
        }
        return defaultProvider.getSchemaName(object);
    }

    static {
        NO_AVRO_SERIALIZER_EXCEPTION = new IllegalStateException("No AvroSerializerProvider found on the classpath.");
    }
}

