/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.geojson;

import com.azure.core.experimental.geojson.GeoArray;
import com.azure.core.experimental.geojson.GeoBoundingBox;
import com.azure.core.experimental.geojson.GeoLine;
import com.azure.core.experimental.geojson.GeoObject;
import com.azure.core.experimental.geojson.GeoObjectType;
import com.azure.core.experimental.geojson.GeoPosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class GeoLineCollection
extends GeoObject {
    private final List<GeoLine> lines;

    public GeoLineCollection(List<GeoLine> lines) {
        this(lines, null, null);
    }

    public GeoLineCollection(List<GeoLine> lines, GeoBoundingBox boundingBox, Map<String, Object> customProperties) {
        super(boundingBox, customProperties);
        Objects.requireNonNull(lines, "'lines' cannot be null.");
        this.lines = Collections.unmodifiableList(new ArrayList<GeoLine>(lines));
    }

    public List<GeoLine> getLines() {
        return this.lines;
    }

    public GeoArray<GeoArray<GeoPosition>> getCoordinates() {
        return new GeoArray<GeoArray<GeoPosition>>(this);
    }

    @Override
    public GeoObjectType getType() {
        return GeoObjectType.MULTI_LINE_STRING;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.lines, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof GeoLineCollection)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GeoLineCollection other = (GeoLineCollection)obj;
        return super.equals(obj) && Objects.equals(this.lines, other.lines);
    }
}

