/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.geojson;

import com.azure.core.experimental.geojson.GeoBoundingBox;
import com.azure.core.experimental.geojson.GeoCollection;
import com.azure.core.experimental.geojson.GeoLine;
import com.azure.core.experimental.geojson.GeoLineCollection;
import com.azure.core.experimental.geojson.GeoObjectType;
import com.azure.core.experimental.geojson.GeoPoint;
import com.azure.core.experimental.geojson.GeoPointCollection;
import com.azure.core.experimental.geojson.GeoPolygon;
import com.azure.core.experimental.geojson.GeoPolygonCollection;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonSubTypes(value={@JsonSubTypes.Type(value=GeoPoint.class), @JsonSubTypes.Type(value=GeoLine.class), @JsonSubTypes.Type(value=GeoPolygon.class), @JsonSubTypes.Type(value=GeoPointCollection.class), @JsonSubTypes.Type(value=GeoLineCollection.class), @JsonSubTypes.Type(value=GeoPolygonCollection.class), @JsonSubTypes.Type(value=GeoCollection.class)})
public abstract class GeoObject {
    private final GeoBoundingBox boundingBox;
    private final Map<String, Object> customProperties;

    protected GeoObject(GeoBoundingBox boundingBox, Map<String, Object> customProperties) {
        this.boundingBox = boundingBox;
        this.customProperties = customProperties == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(customProperties));
    }

    public abstract GeoObjectType getType();

    public final GeoBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public final Object getCustomProperty(String name) {
        return this.customProperties == null ? null : this.customProperties.get(name);
    }

    final Map<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public int hashCode() {
        return Objects.hash(this.boundingBox, this.customProperties);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GeoObject)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GeoObject other = (GeoObject)obj;
        return Objects.equals(this.boundingBox, other.boundingBox) && Objects.equals(this.customProperties, other.customProperties);
    }
}

