/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.geojson;

import com.azure.core.experimental.geojson.GeoArray;
import com.azure.core.experimental.geojson.GeoBoundingBox;
import com.azure.core.experimental.geojson.GeoObject;
import com.azure.core.experimental.geojson.GeoObjectType;
import com.azure.core.experimental.geojson.GeoPoint;
import com.azure.core.experimental.geojson.GeoPosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class GeoPointCollection
extends GeoObject {
    private final List<GeoPoint> points;

    public GeoPointCollection(List<GeoPoint> points) {
        this(points, null, null);
    }

    public GeoPointCollection(List<GeoPoint> points, GeoBoundingBox boundingBox, Map<String, Object> customProperties) {
        super(boundingBox, customProperties);
        Objects.requireNonNull(points, "'points' cannot be null.");
        this.points = Collections.unmodifiableList(new ArrayList<GeoPoint>(points));
    }

    public List<GeoPoint> getPoints() {
        return this.points;
    }

    public GeoArray<GeoPosition> getCoordinates() {
        return new GeoArray<GeoPosition>(this);
    }

    @Override
    public GeoObjectType getType() {
        return GeoObjectType.MULTI_POINT;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.points, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof GeoPointCollection)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GeoPointCollection other = (GeoPointCollection)obj;
        return super.equals(obj) && Objects.equals(this.points, other.points);
    }
}

