/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.jdk.httpclient;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.jdk.httpclient.implementation.AzureJdkHttpRequest;
import com.azure.core.http.jdk.httpclient.implementation.JdkHttpResponseAsync;
import com.azure.core.http.jdk.httpclient.implementation.JdkHttpResponseSync;
import com.azure.core.http.jdk.httpclient.implementation.JdkHttpUtils;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Flow;
import reactor.core.publisher.Mono;

class JdkHttpClient
implements HttpClient {
    private static final ClientLogger LOGGER = new ClientLogger(JdkHttpClient.class);
    private static final String AZURE_EAGERLY_READ_RESPONSE = "azure-eagerly-read-response";
    private static final String AZURE_IGNORE_RESPONSE_BODY = "azure-ignore-response-body";
    private final java.net.http.HttpClient jdkHttpClient;
    private final Set<String> restrictedHeaders;

    JdkHttpClient(java.net.http.HttpClient httpClient, Set<String> restrictedHeaders) {
        this.jdkHttpClient = httpClient;
        int javaVersion = JdkHttpClient.getJavaVersion();
        if (javaVersion <= 11) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("JdkAsyncHttpClient is not supported in Java version 11 and below."));
        }
        this.restrictedHeaders = restrictedHeaders;
        LOGGER.verbose("Effective restricted headers: {}", new Object[]{restrictedHeaders});
    }

    public Mono<HttpResponse> send(HttpRequest request) {
        return this.send(request, Context.NONE);
    }

    public Mono<HttpResponse> send(HttpRequest request, Context context) {
        boolean eagerlyReadResponse = context.getData((Object)AZURE_EAGERLY_READ_RESPONSE).orElse(false);
        boolean ignoreResponseBody = context.getData((Object)AZURE_IGNORE_RESPONSE_BODY).orElse(false);
        Mono jdkRequestMono = Mono.fromCallable(() -> this.toJdkHttpRequest(request, context));
        if (eagerlyReadResponse || ignoreResponseBody) {
            return jdkRequestMono.flatMap(jdkRequest -> Mono.fromCompletionStage(this.jdkHttpClient.sendAsync((java.net.http.HttpRequest)jdkRequest, HttpResponse.BodyHandlers.ofByteArray()))).map(jdkResponse -> {
                HttpHeaders headers = JdkHttpUtils.fromJdkHttpHeaders(jdkResponse.headers());
                int statusCode = jdkResponse.statusCode();
                return new JdkHttpResponseSync(request, statusCode, headers, (byte[])jdkResponse.body());
            });
        }
        return jdkRequestMono.flatMap(jdkRequest -> Mono.fromCompletionStage(this.jdkHttpClient.sendAsync((java.net.http.HttpRequest)jdkRequest, HttpResponse.BodyHandlers.ofPublisher()))).map(jdkResponse -> new JdkHttpResponseAsync(request, (java.net.http.HttpResponse<Flow.Publisher<List<ByteBuffer>>>)jdkResponse));
    }

    public HttpResponse sendSync(HttpRequest request, Context context) {
        boolean eagerlyReadResponse = context.getData((Object)AZURE_EAGERLY_READ_RESPONSE).orElse(false);
        boolean ignoreResponseBody = context.getData((Object)AZURE_IGNORE_RESPONSE_BODY).orElse(false);
        java.net.http.HttpRequest jdkRequest = this.toJdkHttpRequest(request, context);
        try {
            if (eagerlyReadResponse || ignoreResponseBody) {
                java.net.http.HttpResponse<byte[]> jdKResponse = this.jdkHttpClient.send(jdkRequest, HttpResponse.BodyHandlers.ofByteArray());
                return new JdkHttpResponseSync(request, jdKResponse.statusCode(), JdkHttpUtils.fromJdkHttpHeaders(jdKResponse.headers()), jdKResponse.body());
            }
            return new JdkHttpResponseSync(request, this.jdkHttpClient.send(jdkRequest, HttpResponse.BodyHandlers.ofInputStream()));
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
        }
        catch (InterruptedException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    private java.net.http.HttpRequest toJdkHttpRequest(HttpRequest request, Context context) {
        return new AzureJdkHttpRequest(request, context, this.restrictedHeaders, LOGGER);
    }

    private static int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (CoreUtils.isNullOrEmpty((CharSequence)version)) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Can't find 'java.version' system property."));
        }
        if (version.startsWith("1.")) {
            if (version.length() < 3) {
                throw LOGGER.logExceptionAsError(new RuntimeException("Can't parse 'java.version':" + version));
            }
            try {
                return Integer.parseInt(version.substring(2, 3));
            }
            catch (Exception t) {
                throw LOGGER.logExceptionAsError(new RuntimeException("Can't parse 'java.version':" + version, t));
            }
        }
        int idx = version.indexOf(".");
        if (idx == -1) {
            return Integer.parseInt(version);
        }
        try {
            return Integer.parseInt(version.substring(0, idx));
        }
        catch (Exception t) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Can't parse 'java.version':" + version, t));
        }
    }
}

