/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.jdk.httpclient.implementation;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.jdk.httpclient.implementation.BodyPublisherUtils;
import com.azure.core.http.jdk.httpclient.implementation.HeaderFilteringMap;
import com.azure.core.implementation.util.HttpHeadersAccessHelper;
import com.azure.core.util.Context;
import com.azure.core.util.Contexts;
import com.azure.core.util.ProgressReporter;
import com.azure.core.util.logging.ClientLogger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import reactor.core.Exceptions;

public final class AzureJdkHttpRequest
extends java.net.http.HttpRequest {
    private final HttpRequest.BodyPublisher bodyPublisher;
    private final String method;
    private final URI uri;
    private final java.net.http.HttpHeaders headers;

    public AzureJdkHttpRequest(HttpRequest azureCoreRequest, Context context, Set<String> restrictedHeaders, ClientLogger logger) {
        HttpMethod method = azureCoreRequest.getHttpMethod();
        ProgressReporter progressReporter = Contexts.with((Context)context).getHttpRequestProgressReporter();
        this.method = method.toString();
        this.bodyPublisher = method == HttpMethod.GET || method == HttpMethod.HEAD ? HttpRequest.BodyPublishers.noBody() : BodyPublisherUtils.toBodyPublisher(azureCoreRequest, progressReporter);
        try {
            this.uri = azureCoreRequest.getUrl().toURI();
        }
        catch (URISyntaxException e) {
            throw logger.logExceptionAsError(Exceptions.propagate((Throwable)e));
        }
        this.headers = java.net.http.HttpHeaders.of(new HeaderFilteringMap(HttpHeadersAccessHelper.getRawHeaderMap((HttpHeaders)azureCoreRequest.getHeaders()), restrictedHeaders, logger), (ignored1, ignored2) -> true);
    }

    @Override
    public Optional<HttpRequest.BodyPublisher> bodyPublisher() {
        return Optional.ofNullable(this.bodyPublisher);
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public Optional<Duration> timeout() {
        return Optional.empty();
    }

    @Override
    public boolean expectContinue() {
        return false;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public Optional<HttpClient.Version> version() {
        return Optional.empty();
    }

    @Override
    public java.net.http.HttpHeaders headers() {
        return this.headers;
    }
}

