/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.jdk.httpclient.implementation;

import com.azure.core.http.HttpRequest;
import com.azure.core.http.jdk.httpclient.implementation.JdkHttpResponseBase;
import com.azure.core.http.jdk.httpclient.implementation.JdkHttpUtils;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import reactor.adapter.JdkFlowAdapter;
import reactor.core.publisher.Flux;

public final class JdkHttpResponseAsync
extends JdkHttpResponseBase {
    private final Flux<ByteBuffer> contentFlux;
    private volatile int disposed = 0;
    private static final AtomicIntegerFieldUpdater<JdkHttpResponseAsync> DISPOSED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(JdkHttpResponseAsync.class, "disposed");

    public JdkHttpResponseAsync(HttpRequest request, HttpResponse<Flow.Publisher<List<ByteBuffer>>> response) {
        super(request, response.statusCode(), JdkHttpUtils.fromJdkHttpHeaders(response.headers()));
        this.contentFlux = JdkFlowAdapter.flowPublisherToFlux(response.body()).flatMapSequential(Flux::fromIterable);
    }

    public Flux<ByteBuffer> getBody() {
        return Flux.using(() -> this, ignored -> this.contentFlux, ignored -> DISPOSED_UPDATER.set(this, 1));
    }

    public void close() {
        if (DISPOSED_UPDATER.compareAndSet(this, 0, 1)) {
            this.contentFlux.subscribe().dispose();
        }
    }
}

