/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.jdk.httpclient;

import com.azure.core.http.HttpClient;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.jdk.httpclient.JdkHttpClient;
import com.azure.core.http.jdk.httpclient.implementation.JdkHttpClientProxySelector;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.http.HttpClient;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;

public class JdkHttpClientBuilder {
    private static final ClientLogger LOGGER = new ClientLogger(JdkHttpClientBuilder.class);
    private static final Duration MINIMUM_TIMEOUT = Duration.ofMillis(1L);
    private static final Duration DEFAULT_CONNECTION_TIMEOUT;
    private static final Duration DEFAULT_WRITE_TIMEOUT;
    private static final Duration DEFAULT_RESPONSE_TIMEOUT;
    private static final Duration DEFAULT_READ_TIMEOUT;
    private static final String JAVA_HOME;
    private static final String JDK_HTTPCLIENT_ALLOW_RESTRICTED_HEADERS = "jdk.httpclient.allowRestrictedHeaders";
    static final Set<String> DEFAULT_RESTRICTED_HEADERS;
    private HttpClient.Builder httpClientBuilder;
    private ProxyOptions proxyOptions;
    private Configuration configuration;
    private Executor executor;
    private Duration connectionTimeout;
    private Duration writeTimeout;
    private Duration responseTimeout;
    private Duration readTimeout;

    public JdkHttpClientBuilder() {
    }

    public JdkHttpClientBuilder(HttpClient.Builder httpClientBuilder) {
        this.httpClientBuilder = Objects.requireNonNull(httpClientBuilder, "'httpClientBuilder' cannot be null.");
    }

    public JdkHttpClientBuilder executor(Executor executor) {
        this.executor = Objects.requireNonNull(executor, "executor can not be null");
        return this;
    }

    public JdkHttpClientBuilder connectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public JdkHttpClientBuilder writeTimeout(Duration writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public JdkHttpClientBuilder responseTimeout(Duration responseTimeout) {
        this.responseTimeout = responseTimeout;
        return this;
    }

    public JdkHttpClientBuilder readTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public JdkHttpClientBuilder proxy(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public JdkHttpClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public HttpClient build() {
        ProxyOptions buildProxyOptions;
        HttpClient.Builder httpClientBuilder = this.httpClientBuilder == null ? java.net.http.HttpClient.newBuilder() : this.httpClientBuilder;
        httpClientBuilder.version(HttpClient.Version.HTTP_1_1);
        httpClientBuilder = httpClientBuilder.connectTimeout(JdkHttpClientBuilder.getTimeout(this.connectionTimeout, DEFAULT_CONNECTION_TIMEOUT));
        Duration writeTimeout = JdkHttpClientBuilder.getTimeout(this.writeTimeout, DEFAULT_WRITE_TIMEOUT);
        Duration responseTimeout = JdkHttpClientBuilder.getTimeout(this.responseTimeout, DEFAULT_RESPONSE_TIMEOUT);
        Duration readTimeout = JdkHttpClientBuilder.getTimeout(this.readTimeout, DEFAULT_READ_TIMEOUT);
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        ProxyOptions proxyOptions = buildProxyOptions = this.proxyOptions == null ? ProxyOptions.fromConfiguration((Configuration)buildConfiguration) : this.proxyOptions;
        if (this.executor != null) {
            httpClientBuilder.executor(this.executor);
        }
        if (buildProxyOptions != null) {
            httpClientBuilder = httpClientBuilder.proxy(new JdkHttpClientProxySelector(buildProxyOptions.getType().toProxyType(), buildProxyOptions.getAddress(), buildProxyOptions.getNonProxyHosts()));
            if (buildProxyOptions.getUsername() != null) {
                httpClientBuilder.authenticator(new ProxyAuthenticator(buildProxyOptions.getUsername(), buildProxyOptions.getPassword()));
            }
        }
        return new JdkHttpClient(httpClientBuilder.build(), Collections.unmodifiableSet(this.getRestrictedHeaders()), writeTimeout, responseTimeout, readTimeout);
    }

    Set<String> getRestrictedHeaders() {
        HashSet<String> restrictedHeaders = new HashSet<String>(DEFAULT_RESTRICTED_HEADERS);
        this.removeAllowedHeaders(restrictedHeaders);
        return restrictedHeaders;
    }

    private void removeAllowedHeaders(Set<String> restrictedHeaders) {
        String[] allowRestrictedHeadersSystemProperties;
        Properties properties = this.getNetworkProperties();
        String[] allowRestrictedHeadersNetProperties = properties.getProperty(JDK_HTTPCLIENT_ALLOW_RESTRICTED_HEADERS, "").split(",");
        Configuration config = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        for (String header : allowRestrictedHeadersSystemProperties = ((String)config.get(JDK_HTTPCLIENT_ALLOW_RESTRICTED_HEADERS, (Object)"")).split(",")) {
            restrictedHeaders.remove(header.trim().toLowerCase(Locale.ROOT));
        }
        for (String header : allowRestrictedHeadersNetProperties) {
            restrictedHeaders.remove(header.trim().toLowerCase(Locale.ROOT));
        }
    }

    Properties getNetworkProperties() {
        Path path = Paths.get(JAVA_HOME, "conf", "net.properties");
        Properties properties = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(path);){
            properties.load(reader);
        }
        catch (IOException e) {
            LOGGER.warning("Cannot read net properties file at path {}", new Object[]{path, e});
        }
        return properties;
    }

    private static Duration getTimeout(Duration configuredTimeout, Duration defaultTimeout) {
        if (configuredTimeout == null) {
            return defaultTimeout;
        }
        return configuredTimeout.compareTo(MINIMUM_TIMEOUT) < 0 ? MINIMUM_TIMEOUT : configuredTimeout;
    }

    static {
        JAVA_HOME = System.getProperty("java.home");
        Configuration configuration = Configuration.getGlobalConfiguration();
        DEFAULT_CONNECTION_TIMEOUT = CoreUtils.getDefaultTimeoutFromEnvironment((Configuration)configuration, (String)"AZURE_REQUEST_CONNECT_TIMEOUT", (Duration)Duration.ofSeconds(10L), (ClientLogger)LOGGER);
        DEFAULT_WRITE_TIMEOUT = CoreUtils.getDefaultTimeoutFromEnvironment((Configuration)configuration, (String)"AZURE_REQUEST_WRITE_TIMEOUT", (Duration)Duration.ofSeconds(60L), (ClientLogger)LOGGER);
        DEFAULT_RESPONSE_TIMEOUT = CoreUtils.getDefaultTimeoutFromEnvironment((Configuration)configuration, (String)"AZURE_REQUEST_RESPONSE_TIMEOUT", (Duration)Duration.ofSeconds(60L), (ClientLogger)LOGGER);
        DEFAULT_READ_TIMEOUT = CoreUtils.getDefaultTimeoutFromEnvironment((Configuration)configuration, (String)"AZURE_REQUEST_READ_TIMEOUT", (Duration)Duration.ofSeconds(60L), (ClientLogger)LOGGER);
        DEFAULT_RESTRICTED_HEADERS = Set.of("connection", "content-length", "expect", "host", "upgrade");
    }

    private static class ProxyAuthenticator
    extends Authenticator {
        private final String userName;
        private final String password;

        ProxyAuthenticator(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.userName, this.password.toCharArray());
        }
    }
}

