/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.jdk.httpclient.implementation;

import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public final class JdkHttpClientProxySelector
extends ProxySelector {
    private final Proxy.Type proxyType;
    private final SocketAddress proxyAddress;
    private final Pattern nonProxyHostsPattern;

    public JdkHttpClientProxySelector(Proxy.Type proxyType, SocketAddress proxyAddress, String nonProxyHosts) {
        this.proxyType = proxyType;
        this.proxyAddress = proxyAddress;
        this.nonProxyHostsPattern = nonProxyHosts == null ? null : Pattern.compile(nonProxyHosts, 2);
    }

    @Override
    public List<Proxy> select(URI uri) {
        return this.nonProxyHostsPattern == null || !this.nonProxyHostsPattern.matcher(uri.getHost()).matches() ? Collections.singletonList(new Proxy(this.proxyType, this.proxyAddress)) : Collections.EMPTY_LIST;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
    }
}

