/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.jdk.httpclient;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpRequest;
import com.azure.core.implementation.util.BinaryDataContent;
import com.azure.core.implementation.util.BinaryDataHelper;
import com.azure.core.implementation.util.ByteArrayContent;
import com.azure.core.implementation.util.FileContent;
import com.azure.core.implementation.util.InputStreamContent;
import com.azure.core.implementation.util.SerializableContent;
import com.azure.core.implementation.util.StringContent;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.ProgressReporter;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.util.concurrent.Flow;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.adapter.JdkFlowAdapter;

final class BodyPublisherUtils {
    private BodyPublisherUtils() {
    }

    /*
     * Unable to fully structure code
     */
    public static HttpRequest.BodyPublisher toBodyPublisher(HttpRequest request, ProgressReporter progressReporter) {
        block4: {
            block3: {
                body = request.getBodyAsBinaryData();
                if (body == null) {
                    return HttpRequest.BodyPublishers.noBody();
                }
                bodyContent = BinaryDataHelper.getContent((BinaryData)body);
                if (!(bodyContent instanceof ByteArrayContent) && !(bodyContent instanceof StringContent) && !(bodyContent instanceof SerializableContent)) break block3;
                publisher = HttpRequest.BodyPublishers.ofByteArray(bodyContent.toBytes());
                break block4;
            }
            if (bodyContent instanceof FileContent) ** GOTO lbl14
            if (bodyContent instanceof InputStreamContent) {
lbl14:
                // 2 sources

                publisher = HttpRequest.BodyPublishers.ofInputStream((Supplier<InputStream>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toStream(), ()Ljava/io/InputStream;)((BinaryDataContent)bodyContent));
            } else {
                publisher = HttpRequest.BodyPublishers.fromPublisher(JdkFlowAdapter.publisherToFlowPublisher((Publisher)request.getBody()));
            }
            publisher = BodyPublisherUtils.toBodyPublisherWithLength(publisher, request.getHeaders().getValue(HttpHeaderName.CONTENT_LENGTH));
        }
        return BodyPublisherUtils.getPublisherWithReporter(publisher, progressReporter);
    }

    private static HttpRequest.BodyPublisher toBodyPublisherWithLength(HttpRequest.BodyPublisher publisher, String contentLength) {
        if (CoreUtils.isNullOrEmpty((CharSequence)contentLength)) {
            return publisher;
        }
        long contentLengthLong = Long.parseLong(contentLength);
        if (contentLengthLong < 1L) {
            return HttpRequest.BodyPublishers.noBody();
        }
        return HttpRequest.BodyPublishers.fromPublisher(publisher, contentLengthLong);
    }

    private static HttpRequest.BodyPublisher getPublisherWithReporter(HttpRequest.BodyPublisher downstream, ProgressReporter progressReporter) {
        return progressReporter == null ? downstream : new CountingPublisher(downstream, progressReporter);
    }

    private static class CountingPublisher
    implements HttpRequest.BodyPublisher {
        private final HttpRequest.BodyPublisher downstream;
        private final ProgressReporter progressReporter;

        CountingPublisher(HttpRequest.BodyPublisher downstream, ProgressReporter progressReporter) {
            this.downstream = downstream;
            this.progressReporter = progressReporter;
        }

        @Override
        public long contentLength() {
            return this.downstream.contentLength();
        }

        @Override
        public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
            this.downstream.subscribe(new CountingSubscriber(subscriber, this.progressReporter));
        }
    }

    private static class CountingSubscriber
    implements Flow.Subscriber<ByteBuffer> {
        private final Flow.Subscriber<? super ByteBuffer> downstream;
        private final ProgressReporter progressReporter;

        CountingSubscriber(Flow.Subscriber<? super ByteBuffer> downstream, ProgressReporter progressReporter) {
            this.downstream = downstream;
            this.progressReporter = progressReporter;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.downstream.onSubscribe(subscription);
        }

        @Override
        public void onNext(ByteBuffer item) {
            this.progressReporter.reportProgress((long)item.remaining());
            this.downstream.onNext(item);
        }

        @Override
        public void onError(Throwable throwable) {
            this.downstream.onError(throwable);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }
    }
}

