/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.jdk.httpclient;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpClientProvider;
import com.azure.core.http.jdk.httpclient.JdkHttpClientBuilder;
import com.azure.core.util.Configuration;
import com.azure.core.util.HttpClientOptions;

public final class JdkHttpClientProvider
implements HttpClientProvider {
    private static final boolean AZURE_ENABLE_HTTP_CLIENT_SHARING = (Boolean)Configuration.getGlobalConfiguration().get("AZURE_ENABLE_HTTP_CLIENT_SHARING", (Object)Boolean.FALSE);
    private final boolean enableHttpClientSharing;

    public JdkHttpClientProvider() {
        this.enableHttpClientSharing = AZURE_ENABLE_HTTP_CLIENT_SHARING;
    }

    JdkHttpClientProvider(Configuration configuration) {
        this.enableHttpClientSharing = (Boolean)configuration.get("AZURE_ENABLE_HTTP_CLIENT_SHARING", (Object)Boolean.FALSE);
    }

    public HttpClient createInstance() {
        if (this.enableHttpClientSharing) {
            return GlobalJdkAsyncHttpClient.HTTP_CLIENT.getHttpClient();
        }
        return new JdkHttpClientBuilder().build();
    }

    public HttpClient createInstance(HttpClientOptions clientOptions) {
        if (clientOptions == null) {
            return this.createInstance();
        }
        JdkHttpClientBuilder builder = new JdkHttpClientBuilder();
        builder = builder.proxy(clientOptions.getProxyOptions()).configuration(clientOptions.getConfiguration()).connectionTimeout(clientOptions.getConnectTimeout());
        return builder.build();
    }

    private static enum GlobalJdkAsyncHttpClient {
        HTTP_CLIENT(new JdkHttpClientBuilder().build());

        private final HttpClient httpClient;

        private GlobalJdkAsyncHttpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
        }

        private HttpClient getHttpClient() {
            return this.httpClient;
        }
    }
}

