/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.jdk.httpclient;

import com.azure.core.http.HttpRequest;
import com.azure.core.http.jdk.httpclient.JdkHttpClient;
import com.azure.core.http.jdk.httpclient.JdkHttpResponseBase;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.Flow;
import reactor.adapter.JdkFlowAdapter;
import reactor.core.publisher.Flux;

final class JdkHttpResponseAsync
extends JdkHttpResponseBase {
    private final Flux<ByteBuffer> contentFlux;
    private volatile boolean disposed = false;

    JdkHttpResponseAsync(HttpRequest request, HttpResponse<Flow.Publisher<List<ByteBuffer>>> response) {
        super(request, response.statusCode(), JdkHttpClient.fromJdkHttpHeaders(response.headers()));
        this.contentFlux = JdkFlowAdapter.flowPublisherToFlux(response.body()).flatMapSequential(Flux::fromIterable);
    }

    public Flux<ByteBuffer> getBody() {
        return Flux.using(() -> this, ignored -> this.contentFlux, ignored -> {
            this.disposed = true;
        });
    }

    public void close() {
        if (!this.disposed) {
            this.disposed = true;
            this.contentFlux.subscribe().dispose();
        }
    }
}

