/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.jdk.httpclient;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import java.nio.charset.Charset;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

abstract class JdkHttpResponseBase
extends HttpResponse {
    private final int statusCode;
    private final HttpHeaders headers;

    JdkHttpResponseBase(HttpRequest request, int statusCode, HttpHeaders headers) {
        super(request);
        this.statusCode = statusCode;
        this.headers = headers;
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    @Deprecated
    public final String getHeaderValue(String name) {
        return this.headers.getValue(name);
    }

    public final String getHeaderValue(HttpHeaderName headerName) {
        return this.headers.getValue(headerName);
    }

    public final HttpHeaders getHeaders() {
        return this.headers;
    }

    public final Mono<String> getBodyAsString() {
        return this.getBodyAsByteArray().map(bytes -> CoreUtils.bomAwareToString((byte[])bytes, (String)this.getHeaderValue(HttpHeaderName.CONTENT_TYPE)));
    }

    public final Mono<String> getBodyAsString(Charset charset) {
        return this.getBodyAsByteArray().map(bytes -> new String((byte[])bytes, charset));
    }

    public Mono<byte[]> getBodyAsByteArray() {
        return FluxUtil.collectBytesFromNetworkResponse((Flux)this.getBody(), (HttpHeaders)this.getHeaders()).flatMap(bytes -> bytes == null || ((byte[])bytes).length == 0 ? Mono.empty() : Mono.just((Object)bytes));
    }
}

