/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.jdk.httpclient.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;

public final class BodyIgnoringSubscriber
implements HttpResponse.BodySubscriber<Void> {
    private final CompletableFuture<Void> completableFuture;
    private final ClientLogger logger;
    private final AtomicBoolean subscribed = new AtomicBoolean();

    public BodyIgnoringSubscriber(ClientLogger logger) {
        this.completableFuture = new CompletableFuture();
        this.logger = logger;
    }

    @Override
    public CompletionStage<Void> getBody() {
        return this.completableFuture;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        if (!this.subscribed.compareAndSet(false, true)) {
            subscription.cancel();
        } else {
            subscription.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onNext(List<ByteBuffer> item) {
        this.logger.log(LogLevel.WARNING, () -> "Received HTTP response body when one wasn't expected. Response body will be ignored as directed.");
    }

    @Override
    public void onError(Throwable throwable) {
        this.completableFuture.completeExceptionally(throwable);
    }

    @Override
    public void onComplete() {
        this.completableFuture.complete(null);
    }
}

