/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty;

import com.azure.core.http.HttpClient;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.netty.NettyAsyncHttpClient;
import com.azure.core.util.logging.ClientLogger;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import reactor.netty.tcp.ProxyProvider;

public class NettyAsyncHttpClientBuilder {
    private final ClientLogger logger = new ClientLogger(NettyAsyncHttpClientBuilder.class);
    private ProxyOptions proxyOptions;
    private boolean enableWiretap;
    private int port = 80;
    private NioEventLoopGroup nioEventLoopGroup;

    public HttpClient build() {
        reactor.netty.http.client.HttpClient nettyHttpClient = reactor.netty.http.client.HttpClient.create().port(this.port).wiretap(this.enableWiretap).tcpConfiguration(tcpConfig -> {
            if (this.nioEventLoopGroup != null) {
                tcpConfig = tcpConfig.runOn((EventLoopGroup)this.nioEventLoopGroup);
            }
            if (this.proxyOptions != null) {
                ProxyProvider.Proxy nettyProxy;
                switch (this.proxyOptions.getType()) {
                    case HTTP: {
                        nettyProxy = ProxyProvider.Proxy.HTTP;
                        break;
                    }
                    case SOCKS4: {
                        nettyProxy = ProxyProvider.Proxy.SOCKS4;
                        break;
                    }
                    case SOCKS5: {
                        nettyProxy = ProxyProvider.Proxy.SOCKS5;
                        break;
                    }
                    default: {
                        throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("Unknown Proxy type '%s' in use. Not configuring Netty proxy.", this.proxyOptions.getType())));
                    }
                }
                return tcpConfig.proxy(ts -> ts.type(nettyProxy).address(this.proxyOptions.getAddress()));
            }
            return tcpConfig;
        });
        return new NettyAsyncHttpClient(nettyHttpClient);
    }

    public NettyAsyncHttpClientBuilder proxy(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public NettyAsyncHttpClientBuilder wiretap(boolean enableWiretap) {
        this.enableWiretap = enableWiretap;
        return this;
    }

    public NettyAsyncHttpClientBuilder port(int port) {
        this.port = port;
        return this;
    }

    public NettyAsyncHttpClientBuilder nioEventLoopGroup(NioEventLoopGroup nioEventLoopGroup) {
        this.nioEventLoopGroup = nioEventLoopGroup;
        return this;
    }
}

