/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty.implementation;

import com.azure.core.http.HttpRequest;
import com.azure.core.http.netty.implementation.NettyAsyncHttpResponseBase;
import com.azure.core.http.netty.implementation.Utility;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.netty.ByteBufFlux;
import reactor.netty.Connection;
import reactor.netty.http.client.HttpClientResponse;

public final class NettyAsyncHttpResponse
extends NettyAsyncHttpResponseBase {
    private final Connection reactorNettyConnection;
    private final boolean disableBufferCopy;

    public NettyAsyncHttpResponse(HttpClientResponse reactorNettyResponse, Connection reactorNettyConnection, HttpRequest httpRequest, boolean disableBufferCopy) {
        super(reactorNettyResponse, httpRequest);
        this.reactorNettyConnection = reactorNettyConnection;
        this.disableBufferCopy = disableBufferCopy;
    }

    public Flux<ByteBuffer> getBody() {
        return this.bodyIntern().doFinally(ignored -> this.close()).map(byteBuf -> this.disableBufferCopy ? byteBuf.nioBuffer() : Utility.deepCopyBuffer(byteBuf));
    }

    public Mono<byte[]> getBodyAsByteArray() {
        return this.bodyIntern().aggregate().asByteArray().doFinally(ignored -> this.close());
    }

    public Mono<String> getBodyAsString() {
        return this.getBodyAsByteArray().map(bytes -> CoreUtils.bomAwareToString((byte[])bytes, (String)this.getHeaderValue("Content-Type")));
    }

    public Mono<String> getBodyAsString(Charset charset) {
        return this.bodyIntern().aggregate().asString(charset).doFinally(ignored -> this.close());
    }

    public Mono<InputStream> getBodyAsInputStream() {
        return this.bodyIntern().aggregate().asInputStream();
    }

    public Mono<Void> writeBodyToAsync(AsynchronousByteChannel channel) {
        return this.bodyIntern().retain().flatMapSequential(nettyBuffer -> FluxUtil.writeToAsynchronousByteChannel((Flux)Flux.just((Object)nettyBuffer.nioBuffer()), (AsynchronousByteChannel)channel).doFinally(ignored -> nettyBuffer.release()), 1, 1).then();
    }

    public void writeBodyTo(WritableByteChannel channel) {
        this.bodyIntern().retain().publishOn(Schedulers.boundedElastic()).map(nettyBuffer -> {
            try {
                ByteBuffer nioBuffer = nettyBuffer.nioBuffer();
                while (nioBuffer.hasRemaining()) {
                    channel.write(nioBuffer);
                }
                ByteBuf byteBuf = nettyBuffer;
                return byteBuf;
            }
            catch (IOException e) {
                throw Exceptions.propagate((Throwable)e);
            }
            finally {
                nettyBuffer.release();
            }
        }).then().block();
    }

    public void close() {
        Utility.closeConnection(this.reactorNettyConnection);
    }

    private ByteBufFlux bodyIntern() {
        return this.reactorNettyConnection.inbound().receive();
    }

    public Connection internConnection() {
        return this.reactorNettyConnection;
    }
}

