/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty;

import com.azure.core.http.HttpClient;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.netty.NettyAsyncHttpClient;
import com.azure.core.util.logging.ClientLogger;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.Objects;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.tcp.ProxyProvider;

public class NettyAsyncHttpClientBuilder {
    private final ClientLogger logger = new ClientLogger(NettyAsyncHttpClientBuilder.class);
    private final reactor.netty.http.client.HttpClient baseHttpClient;
    private ProxyOptions proxyOptions;
    private ConnectionProvider connectionProvider;
    private boolean enableWiretap;
    private int port = 80;
    private NioEventLoopGroup nioEventLoopGroup;
    private boolean disableBufferCopy;

    public NettyAsyncHttpClientBuilder() {
        this.baseHttpClient = null;
    }

    public NettyAsyncHttpClientBuilder(reactor.netty.http.client.HttpClient nettyHttpClient) {
        this.baseHttpClient = Objects.requireNonNull(nettyHttpClient, "'nettyHttpClient' cannot be null.");
    }

    public HttpClient build() {
        reactor.netty.http.client.HttpClient nettyHttpClient;
        if (this.connectionProvider != null) {
            if (this.baseHttpClient != null) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("connectionProvider cannot be set on an existing reactor netty HttpClient."));
            }
            nettyHttpClient = reactor.netty.http.client.HttpClient.create((ConnectionProvider)this.connectionProvider);
        } else {
            nettyHttpClient = this.baseHttpClient == null ? reactor.netty.http.client.HttpClient.create() : this.baseHttpClient;
        }
        nettyHttpClient = nettyHttpClient.port(this.port).wiretap(this.enableWiretap).tcpConfiguration(tcpConfig -> {
            if (this.nioEventLoopGroup != null) {
                tcpConfig = tcpConfig.runOn((EventLoopGroup)this.nioEventLoopGroup);
            }
            if (this.proxyOptions != null) {
                ProxyProvider.Proxy nettyProxy;
                switch (this.proxyOptions.getType()) {
                    case HTTP: {
                        nettyProxy = ProxyProvider.Proxy.HTTP;
                        break;
                    }
                    case SOCKS4: {
                        nettyProxy = ProxyProvider.Proxy.SOCKS4;
                        break;
                    }
                    case SOCKS5: {
                        nettyProxy = ProxyProvider.Proxy.SOCKS5;
                        break;
                    }
                    default: {
                        throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("Unknown Proxy type '%s' in use. Not configuring Netty proxy.", this.proxyOptions.getType())));
                    }
                }
                if (this.proxyOptions.getUsername() != null) {
                    return tcpConfig.proxy(ts -> ts.type(nettyProxy).address(this.proxyOptions.getAddress()).username(this.proxyOptions.getUsername()).password(userName -> this.proxyOptions.getPassword()).build());
                }
                return tcpConfig.proxy(ts -> ts.type(nettyProxy).address(this.proxyOptions.getAddress()));
            }
            return tcpConfig;
        });
        return new NettyAsyncHttpClient(nettyHttpClient, this.disableBufferCopy);
    }

    public NettyAsyncHttpClientBuilder connectionProvider(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
        return this;
    }

    public NettyAsyncHttpClientBuilder proxy(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public NettyAsyncHttpClientBuilder wiretap(boolean enableWiretap) {
        this.enableWiretap = enableWiretap;
        return this;
    }

    public NettyAsyncHttpClientBuilder port(int port) {
        this.port = port;
        return this;
    }

    public NettyAsyncHttpClientBuilder nioEventLoopGroup(NioEventLoopGroup nioEventLoopGroup) {
        this.nioEventLoopGroup = nioEventLoopGroup;
        return this;
    }

    public NettyAsyncHttpClientBuilder disableBufferCopy(boolean disableBufferCopy) {
        this.disableBufferCopy = disableBufferCopy;
        return this;
    }
}

