/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty;

import com.azure.core.http.HttpClient;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.netty.NettyAsyncHttpClient;
import com.azure.core.http.netty.implementation.ChallengeHolder;
import com.azure.core.http.netty.implementation.HttpProxyHandler;
import com.azure.core.util.AuthorizationChallengeHandler;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.proxy.ProxyHandler;
import io.netty.handler.proxy.Socks4ProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import reactor.netty.resources.ConnectionProvider;

public class NettyAsyncHttpClientBuilder {
    private static final String INVALID_PROXY_MESSAGE = "Unknown Proxy type '%s' in use. Not configuring Netty proxy.";
    private final ClientLogger logger = new ClientLogger(NettyAsyncHttpClientBuilder.class);
    private final reactor.netty.http.client.HttpClient baseHttpClient;
    private ProxyOptions proxyOptions;
    private ConnectionProvider connectionProvider;
    private boolean enableWiretap;
    private int port = 80;
    private EventLoopGroup eventLoopGroup;
    private Configuration configuration;
    private boolean disableBufferCopy;

    public NettyAsyncHttpClientBuilder() {
        this.baseHttpClient = null;
    }

    public NettyAsyncHttpClientBuilder(reactor.netty.http.client.HttpClient nettyHttpClient) {
        this.baseHttpClient = Objects.requireNonNull(nettyHttpClient, "'nettyHttpClient' cannot be null.");
    }

    public HttpClient build() {
        reactor.netty.http.client.HttpClient nettyHttpClient = this.baseHttpClient != null ? this.baseHttpClient : (this.connectionProvider != null ? reactor.netty.http.client.HttpClient.create((ConnectionProvider)this.connectionProvider) : reactor.netty.http.client.HttpClient.create());
        nettyHttpClient = nettyHttpClient.port(this.port).wiretap(this.enableWiretap);
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        ProxyOptions buildProxyOptions = this.proxyOptions == null && buildConfiguration != Configuration.NONE ? ProxyOptions.fromConfiguration((Configuration)buildConfiguration) : this.proxyOptions;
        String nonProxyHosts = buildProxyOptions == null ? null : buildProxyOptions.getNonProxyHosts();
        AuthorizationChallengeHandler handler = buildProxyOptions == null || buildProxyOptions.getUsername() == null ? null : new AuthorizationChallengeHandler(buildProxyOptions.getUsername(), buildProxyOptions.getPassword());
        AtomicReference proxyChallengeHolder = new AtomicReference();
        return new NettyAsyncHttpClient(nettyHttpClient, this.eventLoopGroup, () -> this.getProxyHandler(buildProxyOptions, handler, proxyChallengeHolder), nonProxyHosts, this.disableBufferCopy);
    }

    public NettyAsyncHttpClientBuilder connectionProvider(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
        return this;
    }

    public NettyAsyncHttpClientBuilder proxy(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public NettyAsyncHttpClientBuilder wiretap(boolean enableWiretap) {
        this.enableWiretap = enableWiretap;
        return this;
    }

    public NettyAsyncHttpClientBuilder port(int port) {
        this.port = port;
        return this;
    }

    @Deprecated
    public NettyAsyncHttpClientBuilder nioEventLoopGroup(NioEventLoopGroup nioEventLoopGroup) {
        this.eventLoopGroup = nioEventLoopGroup;
        return this;
    }

    public NettyAsyncHttpClientBuilder eventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
        return this;
    }

    public NettyAsyncHttpClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public NettyAsyncHttpClientBuilder disableBufferCopy(boolean disableBufferCopy) {
        this.disableBufferCopy = disableBufferCopy;
        return this;
    }

    private ProxyHandler getProxyHandler(ProxyOptions proxyOptions, AuthorizationChallengeHandler challengeHandler, AtomicReference<ChallengeHolder> proxyChallengeHolder) {
        if (proxyOptions == null) {
            return null;
        }
        switch (proxyOptions.getType()) {
            case HTTP: {
                return new HttpProxyHandler(proxyOptions.getAddress(), challengeHandler, proxyChallengeHolder);
            }
            case SOCKS4: {
                return new Socks4ProxyHandler((SocketAddress)proxyOptions.getAddress(), proxyOptions.getUsername());
            }
            case SOCKS5: {
                return new Socks5ProxyHandler((SocketAddress)proxyOptions.getAddress(), proxyOptions.getUsername(), proxyOptions.getPassword());
            }
        }
        throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(String.format(INVALID_PROXY_MESSAGE, proxyOptions.getType())));
    }
}

