/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty;

import com.azure.core.http.HttpClient;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.netty.NettyAsyncHttpClient;
import com.azure.core.http.netty.implementation.DeferredHttpProxyProvider;
import com.azure.core.util.AuthorizationChallengeHandler;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import reactor.netty.channel.BootstrapHandlers;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.tcp.ProxyProvider;

public class NettyAsyncHttpClientBuilder {
    private final ClientLogger logger = new ClientLogger(NettyAsyncHttpClientBuilder.class);
    private final reactor.netty.http.client.HttpClient baseHttpClient;
    private ProxyOptions proxyOptions;
    private ConnectionProvider connectionProvider;
    private boolean enableWiretap;
    private int port = 80;
    private EventLoopGroup eventLoopGroup;
    private Configuration configuration;
    private boolean disableBufferCopy;

    public NettyAsyncHttpClientBuilder() {
        this.baseHttpClient = null;
    }

    public NettyAsyncHttpClientBuilder(reactor.netty.http.client.HttpClient nettyHttpClient) {
        this.baseHttpClient = Objects.requireNonNull(nettyHttpClient, "'nettyHttpClient' cannot be null.");
    }

    public HttpClient build() {
        reactor.netty.http.client.HttpClient nettyHttpClient = this.baseHttpClient != null ? this.baseHttpClient : (this.connectionProvider != null ? reactor.netty.http.client.HttpClient.create((ConnectionProvider)this.connectionProvider) : reactor.netty.http.client.HttpClient.create());
        nettyHttpClient = nettyHttpClient.port(this.port).wiretap(this.enableWiretap);
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        ProxyOptions buildProxyOptions = this.proxyOptions == null && buildConfiguration != Configuration.NONE ? ProxyOptions.fromConfiguration((Configuration)buildConfiguration) : this.proxyOptions;
        boolean useCustomProxyHandler = NettyAsyncHttpClientBuilder.shouldUseCustomProxyHandler(buildProxyOptions);
        AuthorizationChallengeHandler handler = useCustomProxyHandler ? new AuthorizationChallengeHandler(buildProxyOptions.getUsername(), buildProxyOptions.getPassword()) : null;
        AtomicReference proxyChallengeHolder = useCustomProxyHandler ? new AtomicReference() : null;
        nettyHttpClient = nettyHttpClient.tcpConfiguration(tcpClient -> {
            if (this.eventLoopGroup != null) {
                tcpClient = tcpClient.runOn(this.eventLoopGroup);
            }
            if (buildProxyOptions != null) {
                tcpClient = handler != null ? tcpClient.bootstrap(bootstrap -> BootstrapHandlers.updateConfiguration((Bootstrap)bootstrap, (String)"reactor.left.proxyHandler", (Function)new DeferredHttpProxyProvider(handler, proxyChallengeHolder, buildProxyOptions))) : tcpClient.proxy(proxy -> proxy.type(NettyAsyncHttpClientBuilder.toReactorNettyProxyType(buildProxyOptions.getType(), this.logger)).address(buildProxyOptions.getAddress()).username(buildProxyOptions.getUsername()).password(ignored -> buildProxyOptions.getPassword()).nonProxyHosts(buildProxyOptions.getNonProxyHosts()));
            }
            return tcpClient;
        });
        return new NettyAsyncHttpClient(nettyHttpClient, this.disableBufferCopy);
    }

    public NettyAsyncHttpClientBuilder connectionProvider(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
        return this;
    }

    public NettyAsyncHttpClientBuilder proxy(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public NettyAsyncHttpClientBuilder wiretap(boolean enableWiretap) {
        this.enableWiretap = enableWiretap;
        return this;
    }

    public NettyAsyncHttpClientBuilder port(int port) {
        this.port = port;
        return this;
    }

    @Deprecated
    public NettyAsyncHttpClientBuilder nioEventLoopGroup(NioEventLoopGroup nioEventLoopGroup) {
        this.eventLoopGroup = nioEventLoopGroup;
        return this;
    }

    public NettyAsyncHttpClientBuilder eventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
        return this;
    }

    public NettyAsyncHttpClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public NettyAsyncHttpClientBuilder disableBufferCopy(boolean disableBufferCopy) {
        this.disableBufferCopy = disableBufferCopy;
        return this;
    }

    private static boolean shouldUseCustomProxyHandler(ProxyOptions options) {
        return options != null && options.getUsername() != null && options.getType() == ProxyOptions.Type.HTTP;
    }

    private static ProxyProvider.Proxy toReactorNettyProxyType(ProxyOptions.Type azureProxyType, ClientLogger logger) {
        switch (azureProxyType) {
            case HTTP: {
                return ProxyProvider.Proxy.HTTP;
            }
            case SOCKS4: {
                return ProxyProvider.Proxy.SOCKS4;
            }
            case SOCKS5: {
                return ProxyProvider.Proxy.SOCKS5;
            }
        }
        throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unknown 'ProxyOptions.Type' enum value"));
    }
}

