/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty;

import com.azure.core.http.HttpRequest;
import com.azure.core.http.netty.NettyAsyncHttpClient;
import com.azure.core.http.netty.ReactorNettyHttpResponseBase;
import com.azure.core.util.CoreUtils;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufFlux;
import reactor.netty.Connection;
import reactor.netty.http.client.HttpClientResponse;

final class ReactorNettyHttpResponse
extends ReactorNettyHttpResponseBase {
    private final Connection reactorNettyConnection;
    private final boolean disableBufferCopy;

    ReactorNettyHttpResponse(HttpClientResponse reactorNettyResponse, Connection reactorNettyConnection, HttpRequest httpRequest, boolean disableBufferCopy) {
        super(reactorNettyResponse, httpRequest);
        this.reactorNettyConnection = reactorNettyConnection;
        this.disableBufferCopy = disableBufferCopy;
    }

    public Flux<ByteBuffer> getBody() {
        return this.bodyIntern().doFinally(ignored -> this.close()).map(byteBuf -> this.disableBufferCopy ? byteBuf.nioBuffer() : NettyAsyncHttpClient.deepCopyBuffer(byteBuf));
    }

    public Mono<byte[]> getBodyAsByteArray() {
        return this.bodyIntern().aggregate().asByteArray().doFinally(ignored -> this.close());
    }

    public Mono<String> getBodyAsString() {
        return this.getBodyAsByteArray().map(bytes -> CoreUtils.bomAwareToString((byte[])bytes, (String)this.getHeaderValue("Content-Type")));
    }

    public Mono<String> getBodyAsString(Charset charset) {
        return this.bodyIntern().aggregate().asString(charset).doFinally(ignored -> this.close());
    }

    public void close() {
        NettyAsyncHttpClient.closeConnection(this.reactorNettyConnection);
    }

    private ByteBufFlux bodyIntern() {
        return this.reactorNettyConnection.inbound().receive();
    }

    Connection internConnection() {
        return this.reactorNettyConnection;
    }
}

