/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.netty.implementation.NettyAsyncHttpBufferedResponse;
import com.azure.core.http.netty.implementation.NettyAsyncHttpResponse;
import com.azure.core.http.netty.implementation.Utility;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpMethod;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.NettyOutbound;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpClientResponse;

class NettyAsyncHttpClient
implements HttpClient {
    private final boolean disableBufferCopy;
    final reactor.netty.http.client.HttpClient nettyClient;

    NettyAsyncHttpClient(reactor.netty.http.client.HttpClient nettyClient, boolean disableBufferCopy) {
        this.nettyClient = nettyClient;
        this.disableBufferCopy = disableBufferCopy;
    }

    public Mono<HttpResponse> send(HttpRequest request) {
        return this.send(request, Context.NONE);
    }

    public Mono<HttpResponse> send(HttpRequest request, Context context) {
        Objects.requireNonNull(request.getHttpMethod(), "'request.getHttpMethod()' cannot be null.");
        Objects.requireNonNull(request.getUrl(), "'request.getUrl()' cannot be null.");
        Objects.requireNonNull(request.getUrl().getProtocol(), "'request.getUrl().getProtocol()' cannot be null.");
        boolean eagerlyReadResponse = context.getData((Object)"azure-eagerly-read-response").orElse(false);
        return ((HttpClient.RequestSender)this.nettyClient.request(HttpMethod.valueOf((String)request.getHttpMethod().toString())).uri(request.getUrl().toString())).send(NettyAsyncHttpClient.bodySendDelegate(request)).responseConnection(NettyAsyncHttpClient.responseDelegate(request, this.disableBufferCopy, eagerlyReadResponse)).single();
    }

    private static BiFunction<HttpClientRequest, NettyOutbound, Publisher<Void>> bodySendDelegate(HttpRequest restRequest) {
        return (reactorNettyRequest, reactorNettyOutbound) -> {
            for (HttpHeader hdr : restRequest.getHeaders()) {
                if (reactorNettyRequest.requestHeaders().contains(hdr.getName())) {
                    AtomicBoolean first = new AtomicBoolean(true);
                    hdr.getValuesList().forEach(value -> {
                        if (first.compareAndSet(true, false)) {
                            reactorNettyRequest.header((CharSequence)hdr.getName(), (CharSequence)value);
                        } else {
                            reactorNettyRequest.addHeader((CharSequence)hdr.getName(), (CharSequence)value);
                        }
                    });
                    continue;
                }
                hdr.getValuesList().forEach(value -> reactorNettyRequest.addHeader((CharSequence)hdr.getName(), (CharSequence)value));
            }
            if (restRequest.getBody() != null) {
                Flux nettyByteBufFlux = restRequest.getBody().map(Unpooled::wrappedBuffer);
                return reactorNettyOutbound.send((Publisher)nettyByteBufFlux);
            }
            return reactorNettyOutbound;
        };
    }

    private static BiFunction<HttpClientResponse, Connection, Publisher<HttpResponse>> responseDelegate(HttpRequest restRequest, boolean disableBufferCopy, boolean eagerlyReadResponse) {
        return (reactorNettyResponse, reactorNettyConnection) -> {
            if (eagerlyReadResponse) {
                Flux body = reactorNettyConnection.inbound().receive().asByteBuffer().doFinally(ignored -> Utility.closeConnection(reactorNettyConnection));
                return FluxUtil.collectBytesInByteBufferStream((Flux)body).map(bytes -> new NettyAsyncHttpBufferedResponse((HttpClientResponse)reactorNettyResponse, restRequest, (byte[])bytes));
            }
            return Mono.just((Object)((Object)new NettyAsyncHttpResponse((HttpClientResponse)reactorNettyResponse, (Connection)reactorNettyConnection, restRequest, disableBufferCopy)));
        };
    }
}

