/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty.implementation;

import com.azure.core.http.HttpRequest;
import com.azure.core.http.netty.implementation.NettyAsyncHttpResponseBase;
import com.azure.core.util.CoreUtils;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClientResponse;

public final class NettyAsyncHttpBufferedResponse
extends NettyAsyncHttpResponseBase {
    private final byte[] body;

    public NettyAsyncHttpBufferedResponse(HttpClientResponse httpClientResponse, HttpRequest httpRequest, byte[] body) {
        super(httpClientResponse, httpRequest);
        this.body = body;
    }

    public Flux<ByteBuffer> getBody() {
        return Flux.defer(() -> Flux.just((Object)ByteBuffer.wrap(this.body)));
    }

    public Mono<byte[]> getBodyAsByteArray() {
        return Mono.defer(() -> Mono.just((Object)this.body));
    }

    public Mono<String> getBodyAsString() {
        return Mono.defer(() -> Mono.just((Object)CoreUtils.bomAwareToString((byte[])this.body, (String)this.getHeaderValue("Content-Type"))));
    }

    public Mono<String> getBodyAsString(Charset charset) {
        return Mono.defer(() -> Mono.just((Object)new String(this.body, charset)));
    }
}

