/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp;

import com.azure.core.http.HttpClient;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.okhttp.OkHttpAsyncHttpClient;
import com.azure.core.util.logging.ClientLogger;
import java.net.Proxy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class OkHttpAsyncHttpClientBuilder {
    private final ClientLogger logger = new ClientLogger(OkHttpAsyncHttpClientBuilder.class);
    private final OkHttpClient okHttpClient;
    private static final Duration DEFAULT_READ_TIMEOUT = Duration.ofSeconds(120L);
    private static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(60L);
    private List<Interceptor> networkInterceptors = new ArrayList<Interceptor>();
    private Duration readTimeout;
    private Duration connectionTimeout;
    private ConnectionPool connectionPool;
    private Dispatcher dispatcher;
    private ProxyOptions proxyOptions;

    public OkHttpAsyncHttpClientBuilder() {
        this.okHttpClient = null;
    }

    public OkHttpAsyncHttpClientBuilder(OkHttpClient okHttpClient) {
        this.okHttpClient = Objects.requireNonNull(okHttpClient, "'okHttpClient' cannot be null.");
    }

    public OkHttpAsyncHttpClientBuilder addNetworkInterceptor(Interceptor networkInterceptor) {
        Objects.requireNonNull(networkInterceptor, "'networkInterceptor' cannot be null.");
        this.networkInterceptors.add(networkInterceptor);
        return this;
    }

    public OkHttpAsyncHttpClientBuilder networkInterceptors(List<Interceptor> networkInterceptors) {
        this.networkInterceptors = Objects.requireNonNull(networkInterceptors, "'networkInterceptors' cannot be null.");
        return this;
    }

    public OkHttpAsyncHttpClientBuilder readTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder connectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder connectionPool(ConnectionPool connectionPool) {
        this.connectionPool = Objects.requireNonNull(connectionPool, "'connectionPool' cannot be null.");
        return this;
    }

    public OkHttpAsyncHttpClientBuilder dispatcher(Dispatcher dispatcher) {
        this.dispatcher = Objects.requireNonNull(dispatcher, "'dispatcher' cannot be null.");
        return this;
    }

    public OkHttpAsyncHttpClientBuilder proxy(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public HttpClient build() {
        OkHttpClient.Builder httpClientBuilder = this.okHttpClient == null ? new OkHttpClient.Builder() : this.okHttpClient.newBuilder();
        for (Interceptor interceptor : this.networkInterceptors) {
            httpClientBuilder = httpClientBuilder.addNetworkInterceptor(interceptor);
        }
        httpClientBuilder = this.readTimeout != null ? httpClientBuilder.readTimeout(this.readTimeout) : httpClientBuilder.readTimeout(DEFAULT_READ_TIMEOUT);
        httpClientBuilder = this.connectionTimeout != null ? httpClientBuilder.connectTimeout(this.connectionTimeout) : httpClientBuilder.connectTimeout(DEFAULT_CONNECT_TIMEOUT);
        if (this.connectionPool != null) {
            httpClientBuilder = httpClientBuilder.connectionPool(this.connectionPool);
        }
        if (this.dispatcher != null) {
            httpClientBuilder = httpClientBuilder.dispatcher(this.dispatcher);
        }
        if (this.proxyOptions != null) {
            Proxy.Type proxyType;
            switch (this.proxyOptions.getType()) {
                case HTTP: {
                    proxyType = Proxy.Type.HTTP;
                    break;
                }
                case SOCKS4: 
                case SOCKS5: {
                    proxyType = Proxy.Type.SOCKS;
                    break;
                }
                default: {
                    throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("Unknown Proxy type '%s' in use. Not configuring OkHttp proxy.", this.proxyOptions.getType())));
                }
            }
            Proxy proxy = new Proxy(proxyType, this.proxyOptions.getAddress());
            httpClientBuilder = httpClientBuilder.proxy(proxy);
            if (this.proxyOptions.getUsername() != null) {
                httpClientBuilder = httpClientBuilder.proxyAuthenticator((route, response) -> {
                    String credential = Credentials.basic((String)this.proxyOptions.getUsername(), (String)this.proxyOptions.getPassword());
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                });
            }
        }
        return new OkHttpAsyncHttpClient(httpClientBuilder.build());
    }
}

