/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp;

import com.azure.core.http.HttpClient;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.okhttp.OkHttpAsyncHttpClient;
import com.azure.core.http.okhttp.implementation.OkHttpProxySelector;
import com.azure.core.http.okhttp.implementation.ProxyAuthenticator;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.net.ProxySelector;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class OkHttpAsyncHttpClientBuilder {
    private static final ClientLogger LOGGER = new ClientLogger(OkHttpAsyncHttpClientBuilder.class);
    private final OkHttpClient okHttpClient;
    private static final Duration MINIMUM_TIMEOUT = Duration.ofMillis(1L);
    private static final Duration DEFAULT_CONNECT_TIMEOUT;
    private static final Duration DEFAULT_WRITE_TIMEOUT;
    private static final Duration DEFAULT_READ_TIMEOUT;
    private List<Interceptor> networkInterceptors = new ArrayList<Interceptor>();
    private Duration readTimeout;
    private Duration writeTimeout;
    private Duration connectionTimeout;
    private Duration callTimeout;
    private ConnectionPool connectionPool;
    private Dispatcher dispatcher;
    private ProxyOptions proxyOptions;
    private Configuration configuration;
    private boolean followRedirects;

    public OkHttpAsyncHttpClientBuilder() {
        this.okHttpClient = null;
    }

    public OkHttpAsyncHttpClientBuilder(OkHttpClient okHttpClient) {
        this.okHttpClient = Objects.requireNonNull(okHttpClient, "'okHttpClient' cannot be null.");
    }

    public OkHttpAsyncHttpClientBuilder addNetworkInterceptor(Interceptor networkInterceptor) {
        Objects.requireNonNull(networkInterceptor, "'networkInterceptor' cannot be null.");
        this.networkInterceptors.add(networkInterceptor);
        return this;
    }

    public OkHttpAsyncHttpClientBuilder networkInterceptors(List<Interceptor> networkInterceptors) {
        this.networkInterceptors = Objects.requireNonNull(networkInterceptors, "'networkInterceptors' cannot be null.");
        return this;
    }

    public OkHttpAsyncHttpClientBuilder readTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder writeTimeout(Duration writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder connectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder callTimeout(Duration callTimeout) {
        if (callTimeout != null && callTimeout.isNegative()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'callTimeout' cannot be negative"));
        }
        this.callTimeout = callTimeout;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder connectionPool(ConnectionPool connectionPool) {
        this.connectionPool = Objects.requireNonNull(connectionPool, "'connectionPool' cannot be null.");
        return this;
    }

    public OkHttpAsyncHttpClientBuilder dispatcher(Dispatcher dispatcher) {
        this.dispatcher = Objects.requireNonNull(dispatcher, "'dispatcher' cannot be null.");
        return this;
    }

    public OkHttpAsyncHttpClientBuilder proxy(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public HttpClient build() {
        ProxyOptions buildProxyOptions;
        OkHttpClient.Builder httpClientBuilder = this.okHttpClient == null ? new OkHttpClient.Builder() : this.okHttpClient.newBuilder();
        for (Interceptor interceptor : this.networkInterceptors) {
            httpClientBuilder = httpClientBuilder.addNetworkInterceptor(interceptor);
        }
        httpClientBuilder = httpClientBuilder.connectTimeout(OkHttpAsyncHttpClientBuilder.getTimeout(this.connectionTimeout, DEFAULT_CONNECT_TIMEOUT)).writeTimeout(OkHttpAsyncHttpClientBuilder.getTimeout(this.writeTimeout, DEFAULT_WRITE_TIMEOUT)).readTimeout(OkHttpAsyncHttpClientBuilder.getTimeout(this.readTimeout, DEFAULT_READ_TIMEOUT));
        if (this.callTimeout != null) {
            httpClientBuilder.callTimeout(this.callTimeout);
        }
        if (this.connectionPool != null) {
            httpClientBuilder = httpClientBuilder.connectionPool(this.connectionPool);
        }
        if (this.dispatcher != null) {
            httpClientBuilder = httpClientBuilder.dispatcher(this.dispatcher);
        }
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        ProxyOptions proxyOptions = buildProxyOptions = this.proxyOptions == null ? ProxyOptions.fromConfiguration((Configuration)buildConfiguration, (boolean)true) : this.proxyOptions;
        if (buildProxyOptions != null) {
            httpClientBuilder = httpClientBuilder.proxySelector((ProxySelector)new OkHttpProxySelector(buildProxyOptions.getType().toProxyType(), () -> ((ProxyOptions)buildProxyOptions).getAddress(), buildProxyOptions.getNonProxyHosts()));
            if (buildProxyOptions.getUsername() != null) {
                ProxyAuthenticator proxyAuthenticator = new ProxyAuthenticator(buildProxyOptions.getUsername(), buildProxyOptions.getPassword());
                httpClientBuilder = httpClientBuilder.proxyAuthenticator((Authenticator)proxyAuthenticator).addInterceptor(proxyAuthenticator.getProxyAuthenticationInfoInterceptor());
            }
        }
        httpClientBuilder.followRedirects(this.followRedirects);
        return new OkHttpAsyncHttpClient(httpClientBuilder.build());
    }

    static Duration getTimeout(Duration configuredTimeout, Duration defaultTimeout) {
        if (configuredTimeout == null) {
            return defaultTimeout;
        }
        if (configuredTimeout.isZero() || configuredTimeout.isNegative()) {
            return Duration.ZERO;
        }
        if (configuredTimeout.compareTo(MINIMUM_TIMEOUT) < 0) {
            return MINIMUM_TIMEOUT;
        }
        return configuredTimeout;
    }

    static {
        ClientLogger logger = new ClientLogger(OkHttpAsyncHttpClientBuilder.class);
        Configuration configuration = Configuration.getGlobalConfiguration();
        DEFAULT_CONNECT_TIMEOUT = CoreUtils.getDefaultTimeoutFromEnvironment((Configuration)configuration, (String)"AZURE_REQUEST_CONNECT_TIMEOUT", (Duration)Duration.ofSeconds(10L), (ClientLogger)logger);
        DEFAULT_WRITE_TIMEOUT = CoreUtils.getDefaultTimeoutFromEnvironment((Configuration)configuration, (String)"AZURE_REQUEST_WRITE_TIMEOUT", (Duration)Duration.ofSeconds(60L), (ClientLogger)logger);
        DEFAULT_READ_TIMEOUT = CoreUtils.getDefaultTimeoutFromEnvironment((Configuration)configuration, (String)"AZURE_REQUEST_READ_TIMEOUT", (Duration)Duration.ofSeconds(60L), (ClientLogger)logger);
    }
}

