/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp.implementation;

import com.azure.core.http.okhttp.implementation.OkHttpStreamableRequestBody;
import com.azure.core.implementation.util.BinaryDataContent;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.MediaType;
import okio.BufferedSink;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class OkHttpFluxRequestBody
extends OkHttpStreamableRequestBody<BinaryDataContent> {
    private static final ClientLogger LOGGER = new ClientLogger(OkHttpFluxRequestBody.class);
    private final AtomicBoolean bodySent = new AtomicBoolean(false);
    private final int callTimeoutMillis;

    public OkHttpFluxRequestBody(BinaryDataContent content, long effectiveContentLength, MediaType mediaType, int callTimeoutMillis) {
        super(content, effectiveContentLength, mediaType);
        this.callTimeoutMillis = callTimeoutMillis;
    }

    public void writeTo(BufferedSink bufferedSink) throws IOException {
        if (this.bodySent.compareAndSet(false, true)) {
            Mono requestSendMono = this.content.toFluxByteBuffer().flatMapSequential(buffer -> {
                if (Schedulers.isInNonBlockingThread()) {
                    return Mono.just((Object)buffer).publishOn(Schedulers.boundedElastic()).map(b -> this.writeBuffer(bufferedSink, (ByteBuffer)b)).then();
                }
                this.writeBuffer(bufferedSink, (ByteBuffer)buffer);
                return Mono.empty();
            }, 1, 1).then();
            if (this.callTimeoutMillis > 0) {
                requestSendMono.block(Duration.ofMillis(this.callTimeoutMillis));
            } else {
                requestSendMono.block();
            }
        } else {
            throw (IOException)LOGGER.logThrowableAsError((Throwable)new IOException("Re-attempt to send Flux body is not supported"));
        }
    }

    private ByteBuffer writeBuffer(BufferedSink sink, ByteBuffer buffer) {
        try {
            while (buffer.hasRemaining()) {
                sink.write(buffer);
            }
            return buffer;
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }
}

