/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp.implementation;

import com.azure.core.implementation.util.BinaryDataContent;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.RequestBody;

public abstract class OkHttpStreamableRequestBody<T extends BinaryDataContent>
extends RequestBody {
    protected final T content;
    protected final long effectiveContentLength;
    private final MediaType mediaType;

    public OkHttpStreamableRequestBody(T content, long effectiveContentLength, MediaType mediaType) {
        this.content = (BinaryDataContent)Objects.requireNonNull(content, "'content' cannot be null.");
        this.effectiveContentLength = effectiveContentLength;
        this.mediaType = mediaType;
    }

    public final MediaType contentType() {
        return this.mediaType;
    }

    public final long contentLength() {
        return this.effectiveContentLength;
    }
}

