/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp.implementation;

import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.okhttp.implementation.OkHttpAsyncResponseBase;
import com.azure.core.util.BinaryData;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import okhttp3.Response;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class OkHttpAsyncBufferedResponse
extends OkHttpAsyncResponseBase {
    private final byte[] body;

    public OkHttpAsyncBufferedResponse(Response response, HttpRequest request, byte[] body) {
        super(response, request);
        this.body = body;
    }

    public BinaryData getBodyAsBinaryData() {
        return BinaryData.fromBytes((byte[])this.body);
    }

    public Flux<ByteBuffer> getBody() {
        return Mono.fromSupplier(() -> ByteBuffer.wrap(this.body)).flux();
    }

    public Mono<byte[]> getBodyAsByteArray() {
        return Mono.just((Object)this.body);
    }

    public Mono<InputStream> getBodyAsInputStream() {
        return Mono.fromSupplier(() -> new ByteArrayInputStream(this.body));
    }

    public HttpResponse buffer() {
        return this;
    }
}

