/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp.implementation;

import com.azure.core.http.okhttp.implementation.PerCallTimeoutCall;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.HttpUrl;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;

public class ResponseTimeoutListener
extends EventListener {
    private final EventListener delegate;

    public ResponseTimeoutListener(EventListener delegate) {
        this.delegate = delegate;
    }

    public void requestHeadersEnd(Call call, Request request) {
        PerCallTimeoutCall perCallTimeoutCall = (PerCallTimeoutCall)request.tag(PerCallTimeoutCall.class);
        if (perCallTimeoutCall != null && request.body() == null) {
            perCallTimeoutCall.beginPerCallTimeout(call);
        }
        this.delegate.requestHeadersEnd(call, request);
    }

    public void requestFailed(Call call, IOException ioe) {
        PerCallTimeoutCall perCallTimeoutCall = (PerCallTimeoutCall)call.request().tag(PerCallTimeoutCall.class);
        if (perCallTimeoutCall != null) {
            perCallTimeoutCall.endPerCallTimeout();
        }
        this.delegate.requestFailed(call, ioe);
    }

    public void requestBodyEnd(Call call, long byteCount) {
        PerCallTimeoutCall perCallTimeoutCall = (PerCallTimeoutCall)call.request().tag(PerCallTimeoutCall.class);
        if (perCallTimeoutCall != null) {
            perCallTimeoutCall.beginPerCallTimeout(call);
        }
        this.delegate.requestBodyEnd(call, byteCount);
    }

    public void responseHeadersStart(Call call) {
        PerCallTimeoutCall perCallTimeoutCall = (PerCallTimeoutCall)call.request().tag(PerCallTimeoutCall.class);
        if (perCallTimeoutCall != null) {
            perCallTimeoutCall.endPerCallTimeout();
        }
        this.delegate.responseHeadersStart(call);
    }

    public void responseFailed(Call call, IOException ioe) {
        PerCallTimeoutCall perCallTimeoutCall = (PerCallTimeoutCall)call.request().tag(PerCallTimeoutCall.class);
        if (perCallTimeoutCall != null) {
            perCallTimeoutCall.endPerCallTimeout();
        }
        this.delegate.responseFailed(call, ioe);
    }

    public void canceled(Call call) {
        PerCallTimeoutCall perCallTimeoutCall = (PerCallTimeoutCall)call.request().tag(PerCallTimeoutCall.class);
        if (perCallTimeoutCall != null) {
            perCallTimeoutCall.endPerCallTimeout();
        }
        this.delegate.canceled(call);
    }

    public void cacheConditionalHit(Call call, Response cachedResponse) {
        this.delegate.cacheConditionalHit(call, cachedResponse);
    }

    public void cacheHit(Call call, Response response) {
        this.delegate.cacheHit(call, response);
    }

    public void cacheMiss(Call call) {
        this.delegate.cacheMiss(call);
    }

    public void callEnd(Call call) {
        this.delegate.callEnd(call);
    }

    public void callFailed(Call call, IOException ioe) {
        this.delegate.callFailed(call, ioe);
    }

    public void callStart(Call call) {
        this.delegate.callStart(call);
    }

    public void connectEnd(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, Protocol protocol) {
        this.delegate.connectEnd(call, inetSocketAddress, proxy, protocol);
    }

    public void connectFailed(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, Protocol protocol, IOException ioe) {
        this.delegate.connectFailed(call, inetSocketAddress, proxy, protocol, ioe);
    }

    public void connectStart(Call call, InetSocketAddress inetSocketAddress, Proxy proxy) {
        this.delegate.connectStart(call, inetSocketAddress, proxy);
    }

    public void connectionAcquired(Call call, Connection connection) {
        this.delegate.connectionAcquired(call, connection);
    }

    public void connectionReleased(Call call, Connection connection) {
        this.delegate.connectionReleased(call, connection);
    }

    public void dnsEnd(Call call, String domainName, List<InetAddress> inetAddressList) {
        this.delegate.dnsEnd(call, domainName, inetAddressList);
    }

    public void dnsStart(Call call, String domainName) {
        this.delegate.dnsStart(call, domainName);
    }

    public void proxySelectEnd(Call call, HttpUrl url, List<Proxy> proxies) {
        this.delegate.proxySelectEnd(call, url, proxies);
    }

    public void proxySelectStart(Call call, HttpUrl url) {
        this.delegate.proxySelectStart(call, url);
    }

    public void requestHeadersStart(Call call) {
        this.delegate.requestHeadersStart(call);
    }

    public void requestBodyStart(Call call) {
        this.delegate.requestBodyStart(call);
    }

    public void responseBodyEnd(Call call, long byteCount) {
        this.delegate.responseBodyEnd(call, byteCount);
    }

    public void responseBodyStart(Call call) {
        this.delegate.responseBodyStart(call);
    }

    public void responseHeadersEnd(Call call, Response response) {
        this.delegate.responseHeadersEnd(call, response);
    }

    public void satisfactionFailure(Call call, Response response) {
        this.delegate.satisfactionFailure(call, response);
    }

    public void secureConnectEnd(Call call, Handshake handshake) {
        this.delegate.secureConnectEnd(call, handshake);
    }

    public void secureConnectStart(Call call) {
        this.delegate.secureConnectStart(call);
    }
}

