/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Objects;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.ByteString;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

class OkHttpAsyncHttpClient
implements HttpClient {
    private final OkHttpClient httpClient;
    private static final Mono<ByteString> EMPTY_BYTE_STRING_MONO = Mono.just((Object)ByteString.EMPTY);

    OkHttpAsyncHttpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public Mono<HttpResponse> send(HttpRequest request) {
        return Mono.create(sink -> sink.onRequest(value -> OkHttpAsyncHttpClient.toOkHttpRequest(request).subscribe(okHttpRequest -> {
            Call call = this.httpClient.newCall(okHttpRequest);
            call.enqueue((Callback)new OkHttpCallback((MonoSink<HttpResponse>)sink, request));
            sink.onCancel(() -> ((Call)call).cancel());
        }, arg_0 -> ((MonoSink)sink).error(arg_0))));
    }

    private static Mono<Request> toOkHttpRequest(HttpRequest request) {
        return Mono.just((Object)new Request.Builder()).map(rb -> {
            rb.url(request.getUrl());
            if (request.getHeaders() != null) {
                HashMap<String, String> headers = new HashMap<String, String>();
                for (HttpHeader hdr : request.getHeaders()) {
                    if (hdr.getValue() == null) continue;
                    headers.put(hdr.getName(), hdr.getValue());
                }
                return rb.headers(Headers.of(headers));
            }
            return rb.headers(Headers.of(new HashMap()));
        }).flatMap(rb -> {
            if (request.getHttpMethod() == HttpMethod.GET) {
                return Mono.just((Object)rb.get());
            }
            if (request.getHttpMethod() == HttpMethod.HEAD) {
                return Mono.just((Object)rb.head());
            }
            return OkHttpAsyncHttpClient.toOkHttpRequestBody((Flux<ByteBuffer>)request.getBody(), request.getHeaders()).map(requestBody -> rb.method(request.getHttpMethod().toString(), requestBody));
        }).map(Request.Builder::build);
    }

    private static Mono<RequestBody> toOkHttpRequestBody(Flux<ByteBuffer> bbFlux, HttpHeaders headers) {
        Mono<ByteString> bsMono = bbFlux == null ? EMPTY_BYTE_STRING_MONO : OkHttpAsyncHttpClient.toByteString(bbFlux);
        return bsMono.map(bs -> {
            String contentType = headers.getValue("Content-Type");
            if (contentType == null) {
                return RequestBody.create((ByteString)bs, null);
            }
            return RequestBody.create((ByteString)bs, (MediaType)MediaType.parse((String)contentType));
        });
    }

    private static Mono<ByteString> toByteString(Flux<ByteBuffer> bbFlux) {
        Objects.requireNonNull(bbFlux, "'bbFlux' cannot be null.");
        return Mono.using(Buffer::new, buffer -> bbFlux.reduce(buffer, (b, byteBuffer) -> {
            try {
                b.write(byteBuffer);
                return b;
            }
            catch (IOException ioe) {
                throw Exceptions.propagate((Throwable)ioe);
            }
        }).map(b -> ByteString.of((byte[])b.readByteArray())), Buffer::clear).switchIfEmpty(EMPTY_BYTE_STRING_MONO);
    }

    private static class OkHttpResponse
    extends HttpResponse {
        private final int statusCode;
        private final HttpHeaders headers;
        private final ResponseBody responseBody;
        private static final int BYTE_BUFFER_CHUNK_SIZE = 4096;

        OkHttpResponse(Response innerResponse, HttpRequest request) {
            super(request);
            this.statusCode = innerResponse.code();
            this.headers = OkHttpResponse.fromOkHttpHeaders(innerResponse.headers());
            this.responseBody = innerResponse.body();
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String name) {
            return this.headers.getValue(name);
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public Flux<ByteBuffer> getBody() {
            if (this.responseBody == null) {
                return Flux.empty();
            }
            return Flux.using(() -> this.responseBody.byteStream(), bodyStream -> OkHttpResponse.toFluxByteBuffer(bodyStream), bodyStream -> {
                try {
                    bodyStream.close();
                }
                catch (IOException ioe) {
                    throw Exceptions.propagate((Throwable)ioe);
                }
            }, (boolean)false);
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.fromCallable(() -> {
                if (this.responseBody == null) {
                    return null;
                }
                byte[] content = this.responseBody.bytes();
                if (content.length == 0) {
                    return null;
                }
                return content;
            });
        }

        public Mono<String> getBodyAsString() {
            return Mono.fromCallable(() -> {
                if (this.responseBody == null) {
                    return null;
                }
                String content = this.responseBody.string();
                if (content.length() == 0) {
                    return null;
                }
                return content;
            });
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return this.getBodyAsByteArray().map(bytes -> new String((byte[])bytes, charset));
        }

        public void close() {
            if (this.responseBody != null) {
                this.responseBody.close();
            }
        }

        private static HttpHeaders fromOkHttpHeaders(Headers headers) {
            HttpHeaders httpHeaders = new HttpHeaders();
            for (String headerName : headers.names()) {
                httpHeaders.put(headerName, headers.get(headerName));
            }
            return httpHeaders;
        }

        private static Flux<ByteBuffer> toFluxByteBuffer(InputStream inputStream) {
            Pair pair = new Pair();
            return Flux.just((Object)true).repeat().map(ignore -> {
                byte[] buffer = new byte[4096];
                try {
                    int numBytes = inputStream.read(buffer);
                    if (numBytes > 0) {
                        return pair.buffer(ByteBuffer.wrap(buffer, 0, numBytes)).readBytes(numBytes);
                    }
                    return pair.buffer(null).readBytes(numBytes);
                }
                catch (IOException ioe) {
                    throw Exceptions.propagate((Throwable)ioe);
                }
            }).takeUntil(p -> p.readBytes() == -1).filter(p -> p.readBytes() > 0).map(Pair::buffer);
        }

        private static class Pair {
            private ByteBuffer byteBuffer;
            private int readBytes;

            private Pair() {
            }

            ByteBuffer buffer() {
                return this.byteBuffer;
            }

            int readBytes() {
                return this.readBytes;
            }

            Pair buffer(ByteBuffer byteBuffer) {
                this.byteBuffer = byteBuffer;
                return this;
            }

            Pair readBytes(int cnt) {
                this.readBytes = cnt;
                return this;
            }
        }
    }

    private static class OkHttpCallback
    implements Callback {
        private final MonoSink<HttpResponse> sink;
        private final HttpRequest request;

        OkHttpCallback(MonoSink<HttpResponse> sink, HttpRequest request) {
            this.sink = sink;
            this.request = request;
        }

        public void onFailure(Call call, IOException e) {
            this.sink.error((Throwable)e);
        }

        public void onResponse(Call call, Response response) {
            this.sink.success((Object)new OkHttpResponse(response, this.request));
        }
    }
}

