/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp;

import com.azure.core.http.HttpClient;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.okhttp.OkHttpAsyncHttpClient;
import com.azure.core.http.okhttp.implementation.OkHttpProxySelector;
import com.azure.core.http.okhttp.implementation.ProxyAuthenticator;
import com.azure.core.util.Configuration;
import java.net.ProxySelector;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class OkHttpAsyncHttpClientBuilder {
    private final OkHttpClient okHttpClient;
    private static final Duration MINIMUM_TIMEOUT = Duration.ofMillis(1L);
    private static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(10L);
    private static final Duration DEFAULT_IO_TIMEOUT = Duration.ofSeconds(60L);
    private List<Interceptor> networkInterceptors = new ArrayList<Interceptor>();
    private Duration readTimeout;
    private Duration writeTimeout;
    private Duration connectionTimeout;
    private ConnectionPool connectionPool;
    private Dispatcher dispatcher;
    private ProxyOptions proxyOptions;
    private Configuration configuration;

    public OkHttpAsyncHttpClientBuilder() {
        this.okHttpClient = null;
    }

    public OkHttpAsyncHttpClientBuilder(OkHttpClient okHttpClient) {
        this.okHttpClient = Objects.requireNonNull(okHttpClient, "'okHttpClient' cannot be null.");
    }

    public OkHttpAsyncHttpClientBuilder addNetworkInterceptor(Interceptor networkInterceptor) {
        Objects.requireNonNull(networkInterceptor, "'networkInterceptor' cannot be null.");
        this.networkInterceptors.add(networkInterceptor);
        return this;
    }

    public OkHttpAsyncHttpClientBuilder networkInterceptors(List<Interceptor> networkInterceptors) {
        this.networkInterceptors = Objects.requireNonNull(networkInterceptors, "'networkInterceptors' cannot be null.");
        return this;
    }

    public OkHttpAsyncHttpClientBuilder readTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder writeTimeout(Duration writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder connectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder connectionPool(ConnectionPool connectionPool) {
        this.connectionPool = Objects.requireNonNull(connectionPool, "'connectionPool' cannot be null.");
        return this;
    }

    public OkHttpAsyncHttpClientBuilder dispatcher(Dispatcher dispatcher) {
        this.dispatcher = Objects.requireNonNull(dispatcher, "'dispatcher' cannot be null.");
        return this;
    }

    public OkHttpAsyncHttpClientBuilder proxy(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public HttpClient build() {
        ProxyOptions buildProxyOptions;
        OkHttpClient.Builder httpClientBuilder = this.okHttpClient == null ? new OkHttpClient.Builder() : this.okHttpClient.newBuilder();
        for (Interceptor interceptor : this.networkInterceptors) {
            httpClientBuilder = httpClientBuilder.addNetworkInterceptor(interceptor);
        }
        httpClientBuilder = httpClientBuilder.connectTimeout(OkHttpAsyncHttpClientBuilder.convertConnectTimeout(this.connectionTimeout)).writeTimeout(OkHttpAsyncHttpClientBuilder.convertIoTimeout(this.writeTimeout)).readTimeout(OkHttpAsyncHttpClientBuilder.convertIoTimeout(this.readTimeout));
        if (this.connectionPool != null) {
            httpClientBuilder = httpClientBuilder.connectionPool(this.connectionPool);
        }
        if (this.dispatcher != null) {
            httpClientBuilder = httpClientBuilder.dispatcher(this.dispatcher);
        }
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        ProxyOptions proxyOptions = buildProxyOptions = this.proxyOptions == null && buildConfiguration != Configuration.NONE ? ProxyOptions.fromConfiguration((Configuration)buildConfiguration) : this.proxyOptions;
        if (buildProxyOptions != null) {
            httpClientBuilder = httpClientBuilder.proxySelector((ProxySelector)new OkHttpProxySelector(buildProxyOptions.getType().toProxyType(), buildProxyOptions.getAddress(), buildProxyOptions.getNonProxyHosts()));
            if (buildProxyOptions.getUsername() != null) {
                ProxyAuthenticator proxyAuthenticator = new ProxyAuthenticator(buildProxyOptions.getUsername(), buildProxyOptions.getPassword());
                httpClientBuilder = httpClientBuilder.proxyAuthenticator((Authenticator)proxyAuthenticator).addInterceptor(proxyAuthenticator.getProxyAuthenticationInfoInterceptor());
            }
        }
        return new OkHttpAsyncHttpClient(httpClientBuilder.build());
    }

    private static Duration convertConnectTimeout(Duration timeout) {
        return OkHttpAsyncHttpClientBuilder.convertTimeout(timeout, DEFAULT_CONNECT_TIMEOUT, true);
    }

    private static Duration convertIoTimeout(Duration timeout) {
        return OkHttpAsyncHttpClientBuilder.convertTimeout(timeout, DEFAULT_IO_TIMEOUT, false);
    }

    private static Duration convertTimeout(Duration timeout, Duration defaultTimeout, boolean useDefaultWhenLessThanZero) {
        if (timeout == null) {
            return defaultTimeout;
        }
        if (timeout.isNegative() || timeout.isZero()) {
            return useDefaultWhenLessThanZero ? defaultTimeout : Duration.ZERO;
        }
        return timeout.compareTo(MINIMUM_TIMEOUT) < 0 ? MINIMUM_TIMEOUT : timeout;
    }
}

