/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp;

import com.azure.core.http.HttpRequest;
import com.azure.core.http.okhttp.OkHttpResponseBase;
import java.nio.ByteBuffer;
import okhttp3.Response;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class BufferedOkHttpResponse
extends OkHttpResponseBase {
    private final byte[] body;

    BufferedOkHttpResponse(Response response, HttpRequest request, byte[] body) {
        super(response, request);
        this.body = body;
    }

    public Flux<ByteBuffer> getBody() {
        return Flux.defer(() -> Flux.just((Object)ByteBuffer.wrap(this.body)));
    }

    public Mono<byte[]> getBodyAsByteArray() {
        return Mono.defer(() -> Mono.just((Object)this.body));
    }
}

