/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp;

import com.azure.core.http.HttpRequest;
import com.azure.core.http.okhttp.OkHttpResponseBase;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import okhttp3.Response;
import okhttp3.ResponseBody;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class OkHttpResponse
extends OkHttpResponseBase {
    private static final int BYTE_BUFFER_CHUNK_SIZE = 4096;
    private final ClientLogger logger = new ClientLogger(OkHttpResponse.class);
    private final ResponseBody responseBody;

    OkHttpResponse(Response response, HttpRequest request) {
        super(response, request);
        this.responseBody = response.body();
    }

    public Flux<ByteBuffer> getBody() {
        if (this.responseBody == null) {
            return Flux.empty();
        }
        return Flux.using(() -> ((ResponseBody)this.responseBody).byteStream(), OkHttpResponse::toFluxByteBuffer, bodyStream -> {
            try {
                bodyStream.close();
            }
            catch (IOException ioe) {
                throw this.logger.logExceptionAsError(Exceptions.propagate((Throwable)ioe));
            }
        }, (boolean)false);
    }

    public Mono<byte[]> getBodyAsByteArray() {
        return Mono.fromCallable(() -> {
            if (this.responseBody == null) {
                return null;
            }
            byte[] content = this.responseBody.bytes();
            if (content.length == 0) {
                return null;
            }
            return content;
        });
    }

    public void close() {
        if (this.responseBody != null) {
            this.responseBody.close();
        }
    }

    private static Flux<ByteBuffer> toFluxByteBuffer(InputStream inputStream) {
        Pair pair = new Pair();
        return Flux.just((Object)true).repeat().map(ignore -> {
            byte[] buffer = new byte[4096];
            try {
                int numBytes = inputStream.read(buffer);
                if (numBytes > 0) {
                    return pair.buffer(ByteBuffer.wrap(buffer, 0, numBytes)).readBytes(numBytes);
                }
                return pair.buffer(null).readBytes(numBytes);
            }
            catch (IOException ioe) {
                throw Exceptions.propagate((Throwable)ioe);
            }
        }).takeUntil(p -> p.readBytes() == -1).filter(p -> p.readBytes() > 0).map(Pair::buffer);
    }

    private static class Pair {
        private ByteBuffer byteBuffer;
        private int readBytes;

        private Pair() {
        }

        ByteBuffer buffer() {
            return this.byteBuffer;
        }

        int readBytes() {
            return this.readBytes;
        }

        Pair buffer(ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
            return this;
        }

        Pair readBytes(int cnt) {
            this.readBytes = cnt;
            return this;
        }
    }
}

