/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.CoreUtils;
import java.nio.charset.Charset;
import okhttp3.Headers;
import okhttp3.Response;
import reactor.core.publisher.Mono;

abstract class OkHttpResponseBase
extends HttpResponse {
    private final int statusCode;
    private final HttpHeaders headers;

    OkHttpResponseBase(Response response, HttpRequest request) {
        super(request);
        this.statusCode = response.code();
        this.headers = OkHttpResponseBase.fromOkHttpHeaders(response.headers());
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    public final String getHeaderValue(String name) {
        return this.headers.getValue(name);
    }

    public final HttpHeaders getHeaders() {
        return this.headers;
    }

    public final Mono<String> getBodyAsString() {
        return this.getBodyAsByteArray().map(bytes -> CoreUtils.bomAwareToString((byte[])bytes, (String)this.getHeaderValue("Content-Type")));
    }

    public final Mono<String> getBodyAsString(Charset charset) {
        return this.getBodyAsByteArray().map(bytes -> new String((byte[])bytes, charset));
    }

    private static HttpHeaders fromOkHttpHeaders(Headers headers) {
        HttpHeaders httpHeaders = new HttpHeaders();
        for (String headerName : headers.names()) {
            httpHeaders.put(headerName, headers.get(headerName));
        }
        return httpHeaders;
    }
}

