/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp.implementation;

import com.azure.core.http.HttpRequest;
import com.azure.core.http.okhttp.implementation.OkHttpAsyncResponseBase;
import com.azure.core.util.FluxUtil;
import java.io.InputStream;
import java.nio.ByteBuffer;
import okhttp3.Response;
import okhttp3.ResponseBody;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class OkHttpAsyncResponse
extends OkHttpAsyncResponseBase {
    private static final int BYTE_BUFFER_CHUNK_SIZE = 4096;
    private final ResponseBody responseBody;

    public OkHttpAsyncResponse(Response response, HttpRequest request) {
        super(response, request);
        this.responseBody = response.body();
    }

    public Flux<ByteBuffer> getBody() {
        if (this.responseBody == null) {
            return Flux.empty();
        }
        return Flux.using(() -> ((ResponseBody)this.responseBody).byteStream(), stream -> FluxUtil.toFluxByteBuffer((InputStream)stream, (int)4096), bodyStream -> this.close(), (boolean)false);
    }

    public Mono<byte[]> getBodyAsByteArray() {
        return Mono.fromCallable(() -> {
            if (this.responseBody == null) {
                return null;
            }
            byte[] content = this.responseBody.bytes();
            if (content.length == 0) {
                return null;
            }
            return content;
        });
    }

    public void close() {
        if (this.responseBody != null) {
            this.responseBody.close();
        }
    }
}

