/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpClientProvider;
import com.azure.core.http.okhttp.OkHttpAsyncHttpClientBuilder;
import com.azure.core.util.HttpClientOptions;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;

public final class OkHttpAsyncClientProvider
implements HttpClientProvider {
    public HttpClient createInstance() {
        return new OkHttpAsyncHttpClientBuilder().build();
    }

    public HttpClient createInstance(HttpClientOptions clientOptions) {
        OkHttpAsyncHttpClientBuilder builder = new OkHttpAsyncHttpClientBuilder();
        if (clientOptions != null) {
            builder = builder.proxy(clientOptions.getProxyOptions()).configuration(clientOptions.getConfiguration()).writeTimeout(clientOptions.getWriteTimeout()).readTimeout(clientOptions.getReadTimeout());
            Integer poolSize = clientOptions.getMaximumConnectionPoolSize();
            int maximumConnectionPoolSize = poolSize != null && poolSize > 0 ? poolSize : 5;
            ConnectionPool connectionPool = new ConnectionPool(maximumConnectionPoolSize, clientOptions.getConnectionIdleTimeout().toMillis(), TimeUnit.MILLISECONDS);
            builder = builder.connectionPool(connectionPool);
        }
        return builder.build();
    }
}

