/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp.implementation;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.CoreUtils;
import java.nio.charset.Charset;
import okhttp3.Headers;
import okhttp3.Response;
import reactor.core.publisher.Mono;

abstract class OkHttpAsyncResponseBase
extends HttpResponse {
    private final int statusCode;
    private final HttpHeaders headers;

    OkHttpAsyncResponseBase(Response response, HttpRequest request) {
        super(request);
        this.statusCode = response.code();
        this.headers = OkHttpAsyncResponseBase.fromOkHttpHeaders(response.headers());
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    public final String getHeaderValue(String name) {
        return this.headers.getValue(name);
    }

    public final HttpHeaders getHeaders() {
        return this.headers;
    }

    public final Mono<String> getBodyAsString() {
        return this.getBodyAsByteArray().map(bytes -> CoreUtils.bomAwareToString((byte[])bytes, (String)this.getHeaderValue("Content-Type")));
    }

    public final Mono<String> getBodyAsString(Charset charset) {
        return this.getBodyAsByteArray().map(bytes -> new String((byte[])bytes, charset));
    }

    private static HttpHeaders fromOkHttpHeaders(Headers okHttpHeaders) {
        HttpHeaders azureHeaders = new HttpHeaders();
        okHttpHeaders.names().forEach(name -> azureHeaders.set(name, okHttpHeaders.values(name)));
        return azureHeaders;
    }
}

