/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.vertx;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.vertx.implementation.BufferedVertxHttpResponse;
import com.azure.core.http.vertx.implementation.VertxHttpAsyncResponse;
import com.azure.core.http.vertx.implementation.VertxRequestWriteSubscriber;
import com.azure.core.implementation.util.BinaryDataContent;
import com.azure.core.implementation.util.BinaryDataHelper;
import com.azure.core.implementation.util.ByteArrayContent;
import com.azure.core.implementation.util.ByteBufferContent;
import com.azure.core.implementation.util.FileContent;
import com.azure.core.implementation.util.SerializableContent;
import com.azure.core.implementation.util.StringContent;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.Contexts;
import com.azure.core.util.ProgressReporter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.streams.ReadStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

class VertxAsyncHttpClient
implements HttpClient {
    private static final String AZURE_EAGERLY_READ_RESPONSE = "azure-eagerly-read-response";
    private static final String AZURE_IGNORE_RESPONSE_BODY = "azure-ignore-response-body";
    private final Vertx vertx;
    final io.vertx.core.http.HttpClient client;

    VertxAsyncHttpClient(io.vertx.core.http.HttpClient client, Vertx vertx) {
        this.client = Objects.requireNonNull(client, "client cannot be null");
        this.vertx = Objects.requireNonNull(vertx, "vertx cannot be null");
    }

    public Mono<HttpResponse> send(HttpRequest request) {
        return this.send(request, Context.NONE);
    }

    public Mono<HttpResponse> send(HttpRequest request, Context context) {
        boolean eagerlyReadResponse = context.getData((Object)AZURE_EAGERLY_READ_RESPONSE).orElse(false);
        boolean ignoreResponseBody = context.getData((Object)AZURE_IGNORE_RESPONSE_BODY).orElse(false);
        ProgressReporter progressReporter = Contexts.with((Context)context).getHttpRequestProgressReporter();
        RequestOptions options = new RequestOptions().setMethod(HttpMethod.valueOf((String)request.getHttpMethod().name())).setAbsoluteURI(request.getUrl());
        return Mono.create(sink -> this.client.request(options, requestResult -> {
            if (requestResult.failed()) {
                sink.error(requestResult.cause());
                return;
            }
            HttpClientRequest vertxRequest = (HttpClientRequest)requestResult.result();
            for (HttpHeader header : request.getHeaders()) {
                vertxRequest.putHeader(header.getName(), (Iterable)header.getValuesList());
            }
            if (request.getHeaders().get(HttpHeaderName.CONTENT_LENGTH) == null) {
                vertxRequest.setChunked(true);
            }
            vertxRequest.response(event -> {
                if (event.succeeded()) {
                    HttpClientResponse vertxHttpResponse = (HttpClientResponse)event.result();
                    vertxHttpResponse.exceptionHandler(arg_0 -> ((MonoSink)sink).error(arg_0));
                    if (eagerlyReadResponse || ignoreResponseBody) {
                        vertxHttpResponse.body(bodyEvent -> {
                            if (bodyEvent.succeeded()) {
                                sink.success((Object)new BufferedVertxHttpResponse(request, vertxHttpResponse, (Buffer)bodyEvent.result()));
                            } else {
                                sink.error(bodyEvent.cause());
                            }
                        });
                    } else {
                        sink.success((Object)new VertxHttpAsyncResponse(request, vertxHttpResponse));
                    }
                } else {
                    sink.error(event.cause());
                }
            });
            this.sendBody((MonoSink<HttpResponse>)sink, request, progressReporter, vertxRequest);
        }));
    }

    public HttpResponse sendSync(HttpRequest request, Context context) {
        return (HttpResponse)this.send(request, context).block();
    }

    private void sendBody(MonoSink<HttpResponse> sink, HttpRequest azureRequest, ProgressReporter progressReporter, HttpClientRequest vertxRequest) {
        BinaryData body = azureRequest.getBodyAsBinaryData();
        if (body == null) {
            vertxRequest.send(result -> {
                if (result.failed()) {
                    sink.error(result.cause());
                }
            });
            return;
        }
        BinaryDataContent bodyContent = BinaryDataHelper.getContent((BinaryData)body);
        if (bodyContent instanceof ByteArrayContent || bodyContent instanceof StringContent || bodyContent instanceof SerializableContent) {
            byte[] content = bodyContent.toBytes();
            vertxRequest.send(Buffer.buffer((ByteBuf)Unpooled.wrappedBuffer((byte[])content)), result -> {
                if (result.succeeded()) {
                    VertxAsyncHttpClient.reportProgress(content.length, progressReporter);
                } else {
                    sink.error(result.cause());
                }
            });
        } else if (bodyContent instanceof ByteBufferContent) {
            long contentLength = bodyContent.getLength();
            vertxRequest.send(Buffer.buffer((ByteBuf)Unpooled.wrappedBuffer((ByteBuffer)bodyContent.toByteBuffer())), result -> {
                if (result.succeeded()) {
                    VertxAsyncHttpClient.reportProgress(contentLength, progressReporter);
                } else {
                    sink.error(result.cause());
                }
            });
        } else if (bodyContent instanceof FileContent) {
            FileContent fileContent = (FileContent)bodyContent;
            this.vertx.fileSystem().open(fileContent.getFile().toString(), new OpenOptions().setRead(true), event -> {
                if (event.succeeded()) {
                    AsyncFile file = (AsyncFile)event.result();
                    file.setReadPos(fileContent.getPosition());
                    if (fileContent.getLength() != null) {
                        file.setReadLength(fileContent.getLength().longValue());
                    }
                    vertxRequest.send((ReadStream)file, result -> {
                        if (result.succeeded()) {
                            VertxAsyncHttpClient.reportProgress(fileContent.getLength(), progressReporter);
                        } else {
                            sink.error(result.cause());
                        }
                    });
                } else {
                    sink.error(event.cause());
                }
            });
        } else {
            azureRequest.getBody().subscribe((Subscriber)new VertxRequestWriteSubscriber(vertxRequest, sink, progressReporter));
        }
    }

    private static void reportProgress(long progress, ProgressReporter progressReporter) {
        if (progressReporter != null) {
            progressReporter.reportProgress(progress);
        }
    }
}

