/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.vertx.implementation;

import com.azure.core.http.HttpResponse;
import com.azure.core.util.ProgressReporter;
import com.azure.core.util.logging.ClientLogger;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import java.nio.ByteBuffer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.MonoSink;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public final class VertxRequestWriteSubscriber
implements Subscriber<ByteBuffer> {
    private static final ClientLogger LOGGER = new ClientLogger(VertxRequestWriteSubscriber.class);
    private final HttpClientRequest request;
    private final MonoSink<HttpResponse> emitter;
    private final ProgressReporter progressReporter;
    private volatile Subscription subscription;
    private volatile State state = State.UNINITIALIZED;
    private volatile Throwable error;

    public VertxRequestWriteSubscriber(HttpClientRequest request, MonoSink<HttpResponse> emitter, ProgressReporter progressReporter) {
        this.request = request.exceptionHandler(this::onError).drainHandler(ignored -> this.requestNext());
        this.emitter = emitter;
        this.progressReporter = progressReporter;
    }

    public void onSubscribe(Subscription s) {
        if (Operators.validate((Subscription)this.subscription, (Subscription)s)) {
            this.subscription = s;
            s.request(1L);
        }
    }

    public void onNext(ByteBuffer bytes) {
        try {
            if (this.state == State.WRITING) {
                this.onErrorInternal(new IllegalStateException("Received onNext while processing another write operation."));
            } else {
                this.state = State.WRITING;
                this.write(bytes);
            }
        }
        catch (Exception ex) {
            this.onErrorInternal(ex);
        }
    }

    private void write(ByteBuffer bytes) {
        int remaining = bytes.remaining();
        this.request.write((Object)Buffer.buffer((ByteBuf)Unpooled.wrappedBuffer((ByteBuffer)bytes)), result -> {
            State state = this.state;
            if (state == State.WRITING) {
                this.state = State.UNINITIALIZED;
            }
            if (result.succeeded()) {
                if (this.progressReporter != null) {
                    this.progressReporter.reportProgress((long)remaining);
                }
                if (state == State.WRITING) {
                    if (!this.request.writeQueueFull()) {
                        this.requestNext();
                    }
                } else if (state == State.COMPLETE) {
                    this.endRequest();
                } else if (state == State.ERROR) {
                    this.resetRequest(this.error);
                }
            } else {
                this.state = State.ERROR;
                this.resetRequest(result.cause());
            }
        });
    }

    private void requestNext() {
        if (this.state == State.UNINITIALIZED) {
            this.subscription.request(1L);
        }
    }

    public void onError(Throwable throwable) {
        this.onErrorInternal(throwable);
    }

    private void onErrorInternal(Throwable throwable) {
        State state = this.state;
        if (state.code >= 2) {
            Operators.onErrorDropped((Throwable)throwable, (Context)Context.of((ContextView)this.emitter.contextView()));
        }
        this.state = State.ERROR;
        if (state != State.WRITING) {
            this.resetRequest(throwable);
        } else {
            this.error = throwable;
        }
    }

    private void resetRequest(Throwable throwable) {
        this.subscription.cancel();
        this.emitter.error(LOGGER.logThrowableAsError(throwable));
        this.request.reset(0L, throwable);
    }

    public void onComplete() {
        State state = this.state;
        if (state.code >= 2) {
            return;
        }
        this.state = State.COMPLETE;
        if (state != State.WRITING) {
            this.endRequest();
        }
    }

    private void endRequest() {
        this.request.end(result -> {
            if (result.failed()) {
                this.emitter.error(result.cause());
            }
        });
    }

    private static enum State {
        UNINITIALIZED(0),
        WRITING(1),
        COMPLETE(2),
        ERROR(3);

        private final int code;

        private State(int code) {
            this.code = code;
        }
    }
}

