/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.vertx;

import com.azure.core.http.HttpClient;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.vertx.VertxAsyncHttpClient;
import com.azure.core.http.vertx.VertxProvider;
import com.azure.core.implementation.util.HttpUtils;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.net.ProxyType;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class VertxAsyncHttpClientBuilder {
    private static final ClientLogger LOGGER = new ClientLogger(VertxAsyncHttpClientBuilder.class);
    private static final Pattern NON_PROXY_HOSTS_SPLIT = Pattern.compile("(?<!\\\\)\\|");
    private static final Pattern NON_PROXY_HOST_DESANITIZE = Pattern.compile("(\\?|\\\\|\\(|\\)|\\\\E|\\\\Q|\\.\\.)");
    private static final Pattern NON_PROXY_HOST_DOT_STAR = Pattern.compile("(\\.\\*)");
    private Duration connectTimeout;
    private Duration writeTimeout;
    private Duration responseTimeout;
    private Duration readTimeout;
    private ProxyOptions proxyOptions;
    private Configuration configuration;
    private HttpClientOptions httpClientOptions;
    private Vertx vertx;

    public VertxAsyncHttpClientBuilder connectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public VertxAsyncHttpClientBuilder readTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public VertxAsyncHttpClientBuilder responseTimeout(Duration responseTimeout) {
        this.responseTimeout = responseTimeout;
        return this;
    }

    public VertxAsyncHttpClientBuilder writeTimeout(Duration writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public VertxAsyncHttpClientBuilder proxy(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public VertxAsyncHttpClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public VertxAsyncHttpClientBuilder httpClientOptions(HttpClientOptions httpClientOptions) {
        this.httpClientOptions = httpClientOptions;
        return this;
    }

    public VertxAsyncHttpClientBuilder vertx(Vertx vertx) {
        this.vertx = vertx;
        return this;
    }

    public HttpClient build() {
        HttpClientOptions buildOptions;
        Vertx configuredVertx = this.vertx;
        if (configuredVertx == null) {
            ServiceLoader<VertxProvider> vertxProviders = ServiceLoader.load(VertxProvider.class, VertxProvider.class.getClassLoader());
            configuredVertx = VertxAsyncHttpClientBuilder.getVertx(vertxProviders.iterator());
        }
        if ((buildOptions = this.httpClientOptions) == null) {
            ProxyOptions buildProxyOptions;
            buildOptions = new HttpClientOptions().setIdleTimeoutUnit(TimeUnit.MILLISECONDS).setConnectTimeout((int)HttpUtils.getTimeout((Duration)this.connectTimeout, (Duration)HttpUtils.getDefaultConnectTimeout()).toMillis()).setReadIdleTimeout((int)HttpUtils.getTimeout((Duration)this.readTimeout, (Duration)HttpUtils.getDefaultReadTimeout()).toMillis()).setWriteIdleTimeout((int)HttpUtils.getTimeout((Duration)this.writeTimeout, (Duration)HttpUtils.getDefaultWriteTimeout()).toMillis());
            Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
            ProxyOptions proxyOptions = buildProxyOptions = this.proxyOptions == null ? ProxyOptions.fromConfiguration((Configuration)buildConfiguration, (boolean)true) : this.proxyOptions;
            if (buildProxyOptions != null) {
                String nonProxyHosts;
                ProxyOptions.Type type;
                io.vertx.core.net.ProxyOptions vertxProxyOptions = new io.vertx.core.net.ProxyOptions();
                InetSocketAddress proxyAddress = buildProxyOptions.getAddress();
                if (proxyAddress != null) {
                    vertxProxyOptions.setHost(proxyAddress.getHostName());
                    vertxProxyOptions.setPort(proxyAddress.getPort());
                }
                String proxyUsername = buildProxyOptions.getUsername();
                String proxyPassword = buildProxyOptions.getPassword();
                if (!CoreUtils.isNullOrEmpty((CharSequence)proxyUsername) && !CoreUtils.isNullOrEmpty((CharSequence)proxyPassword)) {
                    vertxProxyOptions.setUsername(proxyUsername);
                    vertxProxyOptions.setPassword(proxyPassword);
                }
                if ((type = buildProxyOptions.getType()) != null) {
                    try {
                        ProxyType proxyType = ProxyType.valueOf((String)type.name());
                        vertxProxyOptions.setType(proxyType);
                    }
                    catch (IllegalArgumentException e) {
                        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unknown Vert.x proxy type: " + type.name(), e));
                    }
                }
                if (!CoreUtils.isNullOrEmpty((CharSequence)(nonProxyHosts = buildProxyOptions.getNonProxyHosts()))) {
                    for (String nonProxyHost : this.desanitizedNonProxyHosts(nonProxyHosts)) {
                        buildOptions.addNonProxyHost(nonProxyHost);
                    }
                }
                buildOptions.setProxyOptions(vertxProxyOptions);
            }
        }
        io.vertx.core.http.HttpClient client = configuredVertx.createHttpClient(buildOptions);
        return new VertxAsyncHttpClient(client, HttpUtils.getTimeout((Duration)this.responseTimeout, (Duration)HttpUtils.getDefaultResponseTimeout()));
    }

    static Vertx getVertx(Iterator<VertxProvider> iterator) {
        Vertx configuredVertx;
        if (iterator.hasNext()) {
            VertxProvider provider = iterator.next();
            configuredVertx = provider.createVertx();
            LOGGER.verbose("Using {} as the VertxProvider.", new Object[]{provider.getClass().getName()});
            while (iterator.hasNext()) {
                VertxProvider ignoredProvider = iterator.next();
                LOGGER.warning("Multiple VertxProviders were found on the classpath, ignoring {}.", new Object[]{ignoredProvider.getClass().getName()});
            }
        } else {
            configuredVertx = DefaultVertx.DEFAULT_VERTX.getVertx();
        }
        return configuredVertx;
    }

    private String[] desanitizedNonProxyHosts(String nonProxyHosts) {
        String desanitzedNonProxyHosts = NON_PROXY_HOST_DESANITIZE.matcher(nonProxyHosts).replaceAll("");
        desanitzedNonProxyHosts = NON_PROXY_HOST_DOT_STAR.matcher(desanitzedNonProxyHosts).replaceAll("*");
        return NON_PROXY_HOSTS_SPLIT.split(desanitzedNonProxyHosts);
    }

    private static Runnable getVertxCloseRunnable(Vertx vertxToClose) {
        return () -> {
            CountDownLatch latch = new CountDownLatch(1);
            if (vertxToClose != null) {
                vertxToClose.close(event -> {
                    if (event.failed() && event.cause() != null) {
                        LOGGER.logThrowableAsError(event.cause());
                    }
                    latch.countDown();
                });
            }
            try {
                if (!latch.await(1L, TimeUnit.MINUTES)) {
                    LOGGER.warning("Timeout closing Vertx");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        };
    }

    private static enum DefaultVertx {
        DEFAULT_VERTX(Vertx.vertx());

        private final Vertx vertx;

        private DefaultVertx(Vertx vertx) {
            this.vertx = vertx;
            Runtime.getRuntime().addShutdownHook(new Thread(VertxAsyncHttpClientBuilder.getVertxCloseRunnable(vertx)));
        }

        private Vertx getVertx() {
            return this.vertx;
        }
    }
}

