/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.management.implementation.polling;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.management.implementation.polling.Error;
import com.azure.core.management.implementation.polling.FinalResult;
import com.azure.core.management.implementation.polling.Util;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;

final class AzureAsyncOperationData {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AzureAsyncOperationData.class);
    @JsonProperty(value="lroRequestMethod", required=true)
    private HttpMethod lroRequestMethod;
    @JsonProperty(value="lroOperationUri", required=true)
    private URL lroOperationUri;
    @JsonProperty(value="pollUrl", required=true)
    private URL pollUrl;
    @JsonProperty(value="locationUrl")
    private URL locationUrl;
    @JsonProperty(value="provisioningState", required=true)
    private String provisioningState;
    @JsonProperty(value="pollError")
    private Error pollError;
    @JsonProperty(value="finalResult")
    private FinalResult finalResult;

    AzureAsyncOperationData() {
    }

    AzureAsyncOperationData(HttpMethod lroRequestMethod, URL lroOperationUri, URL pollUrl, URL locationUrl) {
        this.lroRequestMethod = Objects.requireNonNull(lroRequestMethod, "'lroRequestMethod' cannot be null.");
        this.lroOperationUri = Objects.requireNonNull(lroOperationUri, "'lroOperationUri' cannot be null.");
        this.pollUrl = Objects.requireNonNull(pollUrl, "'pollUrl' cannot be null.");
        this.locationUrl = locationUrl;
        this.provisioningState = "InProgress";
    }

    String getProvisioningState() {
        return this.provisioningState;
    }

    URL getPollUrl() {
        return this.pollUrl;
    }

    Error getPollError() {
        return this.pollError;
    }

    FinalResult getFinalResult() {
        return this.finalResult;
    }

    void update(int pollResponseStatusCode, HttpHeaders pollResponseHeaders, String pollResponseBody, SerializerAdapter adapter) {
        if (pollResponseStatusCode != 200 && pollResponseStatusCode != 201 && pollResponseStatusCode != 202) {
            this.provisioningState = "Failed";
            this.pollError = new Error("Polling failed with status code:" + pollResponseStatusCode, pollResponseStatusCode, pollResponseHeaders.toMap(), pollResponseBody);
        } else {
            AsyncOperationResource resource = AzureAsyncOperationData.tryParseAsyncOperationResource(pollResponseBody, adapter);
            if (resource == null || resource.getProvisioningState() == null) {
                this.provisioningState = "Failed";
                this.pollError = new Error("Polling response does not contain a valid body.", pollResponseStatusCode, pollResponseHeaders.toMap(), pollResponseBody);
            } else {
                this.provisioningState = resource.getProvisioningState();
                if ("Failed".equalsIgnoreCase(this.provisioningState) || "Canceled".equalsIgnoreCase(this.provisioningState)) {
                    this.pollError = new Error("Long running operation is Failed or Cancelled.", pollResponseStatusCode, pollResponseHeaders.toMap(), pollResponseBody);
                } else if ("Succeeded".equalsIgnoreCase(this.provisioningState)) {
                    if (this.lroRequestMethod == HttpMethod.POST || this.lroRequestMethod == HttpMethod.DELETE) {
                        if (this.locationUrl != null) {
                            this.finalResult = new FinalResult(this.locationUrl, null);
                        }
                    } else if (this.lroRequestMethod == HttpMethod.PUT || this.lroRequestMethod == HttpMethod.PATCH) {
                        this.finalResult = new FinalResult(this.lroOperationUri, null);
                    }
                } else {
                    this.updateUrls(pollResponseHeaders);
                }
            }
        }
    }

    private void updateUrls(HttpHeaders pollResponseHeaders) {
        URL locationUrl;
        URL azAsyncOpUrl = Util.getAzureAsyncOperationUrl(pollResponseHeaders, this.logger);
        if (azAsyncOpUrl != null) {
            this.pollUrl = azAsyncOpUrl;
        }
        if ((locationUrl = Util.getLocationUrl(pollResponseHeaders, this.logger)) != null) {
            this.locationUrl = locationUrl;
        }
    }

    private static AsyncOperationResource tryParseAsyncOperationResource(String value, SerializerAdapter adapter) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            return (AsyncOperationResource)adapter.deserialize(value, AsyncOperationResource.class, SerializerEncoding.JSON);
        }
        catch (IOException ignored) {
            return null;
        }
    }

    private static class AsyncOperationResource {
        @JsonProperty(value="status")
        private String provisioningState;

        private AsyncOperationResource() {
        }

        private String getProvisioningState() {
            return this.provisioningState;
        }
    }
}

