/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.management.polling;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.management.implementation.polling.PollOperation;
import com.azure.core.management.implementation.polling.PollingState;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.serializer.SerializerAdapter;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PollerFactory {
    public static <T, U> PollerFlux<PollResult<T>, U> create(SerializerAdapter serializerAdapter, HttpPipeline pipeline, Type pollResultType, Type finalResultType, Duration defaultPollInterval, Mono<Response<Flux<ByteBuffer>>> lroInitMono) {
        return PollerFactory.create(serializerAdapter, pipeline, pollResultType, finalResultType, defaultPollInterval, lroInitMono, Context.NONE);
    }

    public static <T, U> PollerFlux<PollResult<T>, U> create(SerializerAdapter serializerAdapter, HttpPipeline pipeline, Type pollResultType, Type finalResultType, Duration defaultPollInterval, Mono<Response<Flux<ByteBuffer>>> lroInitMono, Context context) {
        Objects.requireNonNull(serializerAdapter, "'serializerAdapter' cannot be null.");
        Objects.requireNonNull(pipeline, "'pipeline' cannot be null.");
        Objects.requireNonNull(pollResultType, "'pollResultType' cannot be null.");
        Objects.requireNonNull(finalResultType, "'finalResultType' cannot be null.");
        Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
        Objects.requireNonNull(lroInitMono, "'lroInitMono' cannot be null.");
        Objects.requireNonNull(context, "'context' cannot be null.");
        Function<PollingContext, Mono> defaultLroInitOperation = pollingContext -> lroInitMono.flatMap(response -> FluxUtil.collectBytesInByteBufferStream((Flux)((Flux)response.getValue())).map(contentBytes -> {
            String content = new String((byte[])contentBytes, StandardCharsets.UTF_8);
            PollingState state = PollingState.create(serializerAdapter, response.getRequest(), response.getStatusCode(), response.getHeaders(), content);
            state.store(pollingContext);
            Object result = PollOperation.deserialize(serializerAdapter, content, pollResultType);
            return new PollResponse(state.getOperationStatus(), new PollResult(result), state.getPollDelay());
        }));
        return PollerFlux.create((Duration)defaultPollInterval, defaultLroInitOperation, PollOperation.pollFunction(serializerAdapter, pipeline, pollResultType, context), PollOperation.cancelFunction(context), PollOperation.fetchResultFunction(serializerAdapter, pipeline, finalResultType, context));
    }

    public static <T, U> PollerFlux<PollResult<T>, U> create(SerializerAdapter serializerAdapter, HttpPipeline pipeline, Type pollResultType, Type finalResultType, Duration defaultPollInterval, Function<PollingContext<PollResult<T>>, Mono<PollResult<T>>> lroInitOperation) {
        return PollerFactory.create(serializerAdapter, pipeline, pollResultType, finalResultType, defaultPollInterval, lroInitOperation, Context.NONE);
    }

    public static <T, U> PollerFlux<PollResult<T>, U> create(SerializerAdapter serializerAdapter, HttpPipeline pipeline, Type pollResultType, Type finalResultType, Duration defaultPollInterval, Function<PollingContext<PollResult<T>>, Mono<PollResult<T>>> lroInitOperation, Context context) {
        Objects.requireNonNull(serializerAdapter, "'serializerAdapter' cannot be null.");
        Objects.requireNonNull(pipeline, "'pipeline' cannot be null.");
        Objects.requireNonNull(pollResultType, "'pollResultType' cannot be null.");
        Objects.requireNonNull(finalResultType, "'finalResultType' cannot be null.");
        Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
        Objects.requireNonNull(lroInitOperation, "'lroInitOperation' cannot be null.");
        Objects.requireNonNull(context, "'context' cannot be null.");
        return new PollerFlux(defaultPollInterval, lroInitOperation, PollOperation.pollFunction(serializerAdapter, pipeline, pollResultType, context), PollOperation.cancelFunction(context), PollOperation.fetchResultFunction(serializerAdapter, pipeline, finalResultType, context));
    }

    public static <T, U> PollerFlux<PollResult<T>, U> create(SerializerAdapter serializerAdapter, HttpPipeline pipeline, Type pollResultType, Type finalResultType, Duration defaultPollInterval, String pollingStateStr) {
        return PollerFactory.create(serializerAdapter, pipeline, pollResultType, finalResultType, defaultPollInterval, pollingStateStr, Context.NONE);
    }

    public static <T, U> PollerFlux<PollResult<T>, U> create(SerializerAdapter serializerAdapter, HttpPipeline pipeline, Type pollResultType, Type finalResultType, Duration defaultPollInterval, String pollingStateStr, Context context) {
        Objects.requireNonNull(serializerAdapter, "'serializerAdapter' cannot be null.");
        Objects.requireNonNull(pipeline, "'pipeline' cannot be null.");
        Objects.requireNonNull(pollResultType, "'pollResultType' cannot be null.");
        Objects.requireNonNull(finalResultType, "'finalResultType' cannot be null.");
        Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
        Objects.requireNonNull(pollingStateStr, "'pollingStateStr' cannot be null.");
        Objects.requireNonNull(context, "'context' cannot be null.");
        return PollerFactory.create(serializerAdapter, pipeline, pollResultType, finalResultType, defaultPollInterval, (PollingContext<PollResult<T>> pollingContext) -> {
            PollingState.from(serializerAdapter, pollingStateStr).store(pollingContext);
            return Mono.empty();
        }, context);
    }
}

